/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.json.builder.internal;

import groovy.json.JsonException;
import groovy.json.internal.ArrayUtils;
import groovy.json.internal.ByteScanner;
import groovy.json.internal.Cache;
import groovy.json.internal.CacheType;
import groovy.json.internal.CharScanner;
import groovy.json.internal.Chr;
import groovy.json.internal.Exceptions;
import groovy.json.internal.FastStringUtils;
import groovy.json.internal.SimpleCache;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CharBuf
extends Writer
implements CharSequence {
    protected int capacity = 16;
    protected int location = 0;
    protected char[] buffer;
    private Cache<Integer, char[]> icache;
    final char[] trueChars = "true".toCharArray();
    final char[] falseChars = "false".toCharArray();
    private Cache<Double, char[]> dcache;
    private Cache<Float, char[]> fcache;
    final byte[] encoded = new byte[2];
    final byte[] charTo = new byte[2];
    private static final char[] EMPTY_STRING_CHARS = Chr.array((char[])new char[]{'\"', '\"'});
    static final char[] nullChars = "null".toCharArray();
    private Cache<BigDecimal, char[]> bigDCache;
    private Cache<BigInteger, char[]> bigICache;
    private Cache<Long, char[]> lcache;

    public CharBuf(char[] buffer) {
        this.__init__(buffer);
    }

    private void __init__(char[] buffer) {
        this.buffer = buffer;
        this.capacity = buffer.length;
    }

    public CharBuf(byte[] bytes) {
        this.buffer = null;
        try {
            String str = new String(bytes, "UTF-8");
            this.__init__(FastStringUtils.toCharArray((String)str));
        }
        catch (UnsupportedEncodingException e) {
            Exceptions.handle((Exception)e);
        }
    }

    public static CharBuf createExact(int capacity) {
        return new CharBuf(capacity){

            @Override
            public CharBuf add(char[] chars) {
                Chr._idx((char[])this.buffer, (int)this.location, (char[])chars);
                this.location += chars.length;
                return this;
            }
        };
    }

    public static CharBuf create(int capacity) {
        return new CharBuf(capacity);
    }

    public static CharBuf create(char[] buffer) {
        return new CharBuf(buffer);
    }

    protected CharBuf(int capacity) {
        this.capacity = capacity;
        this.init();
    }

    protected CharBuf() {
        this.init();
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off == 0 && cbuf.length == len) {
            this.add(cbuf);
        } else {
            char[] buffer = ArrayUtils.copyRange((char[])cbuf, (int)off, (int)(off + len));
            this.add(buffer);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public void init() {
        this.buffer = new char[this.capacity];
    }

    public final CharBuf add(String str) {
        this.add(FastStringUtils.toCharArray((String)str));
        return this;
    }

    public final CharBuf addString(String str) {
        this.add(FastStringUtils.toCharArray((String)str));
        return this;
    }

    public final CharBuf add(int i) {
        this.add(Integer.toString(i));
        return this;
    }

    public final CharBuf addInt(int i) {
        switch (i) {
            case 0: {
                this.addChar('0');
                return this;
            }
            case 1: {
                this.addChar('1');
                return this;
            }
            case -1: {
                this.addChar('-');
                this.addChar('1');
                return this;
            }
        }
        this.addInt((Integer)i);
        return this;
    }

    public final CharBuf addInt(Integer key) {
        char[] chars;
        if (this.icache == null) {
            this.icache = new SimpleCache(20, CacheType.LRU);
        }
        if ((chars = (char[])this.icache.get((Object)key)) == null) {
            String str = Integer.toString(key);
            chars = FastStringUtils.toCharArray((String)str);
            this.icache.put((Object)key, (Object)chars);
        }
        this.addChars(chars);
        return this;
    }

    public final CharBuf add(boolean b) {
        this.addChars(b ? this.trueChars : this.falseChars);
        return this;
    }

    public final CharBuf addBoolean(boolean b) {
        this.add(Boolean.toString(b));
        return this;
    }

    public final CharBuf add(byte i) {
        this.add(Byte.toString(i));
        return this;
    }

    public final CharBuf addByte(byte i) {
        this.addInt(i);
        return this;
    }

    public final CharBuf add(short i) {
        this.add(Short.toString(i));
        return this;
    }

    public final CharBuf addShort(short i) {
        this.addInt(i);
        return this;
    }

    public final CharBuf add(long l) {
        this.add(Long.toString(l));
        return this;
    }

    public final CharBuf add(double d) {
        this.add(Double.toString(d));
        return this;
    }

    public final CharBuf addDouble(double d) {
        this.addDouble((Double)d);
        return this;
    }

    public final CharBuf addDouble(Double key) {
        char[] chars;
        if (this.dcache == null) {
            this.dcache = new SimpleCache(20, CacheType.LRU);
        }
        if ((chars = (char[])this.dcache.get((Object)key)) == null) {
            String str = Double.toString(key);
            chars = FastStringUtils.toCharArray((String)str);
            this.dcache.put((Object)key, (Object)chars);
        }
        this.add(chars);
        return this;
    }

    public final CharBuf add(float d) {
        this.add(Float.toString(d));
        return this;
    }

    public final CharBuf addFloat(float d) {
        this.addFloat(Float.valueOf(d));
        return this;
    }

    public final CharBuf addFloat(Float key) {
        char[] chars;
        if (this.fcache == null) {
            this.fcache = new SimpleCache(20, CacheType.LRU);
        }
        if ((chars = (char[])this.fcache.get((Object)key)) == null) {
            String str = Float.toString(key.floatValue());
            chars = FastStringUtils.toCharArray((String)str);
            this.fcache.put((Object)key, (Object)chars);
        }
        this.add(chars);
        return this;
    }

    public final CharBuf addChar(byte i) {
        this.add((char)i);
        return this;
    }

    public final CharBuf addChar(int i) {
        this.add((char)i);
        return this;
    }

    public final CharBuf addChar(short i) {
        this.add((char)i);
        return this;
    }

    public final CharBuf addChar(char ch) {
        int _location = this.location;
        char[] _buffer = this.buffer;
        int _capacity = this.capacity;
        if (1 + _location > _capacity) {
            _buffer = Chr.grow((char[])_buffer);
            _capacity = _buffer.length;
        }
        _buffer[_location] = ch;
        this.location = ++_location;
        this.buffer = _buffer;
        this.capacity = _capacity;
        return this;
    }

    public CharBuf addLine(String str) {
        this.add(str.toCharArray());
        this.add('\n');
        return this;
    }

    public CharBuf addLine(CharSequence str) {
        this.add(str.toString());
        this.add('\n');
        return this;
    }

    public CharBuf add(char[] chars) {
        if (chars.length + this.location > this.capacity) {
            this.buffer = Chr.grow((char[])this.buffer, (int)(this.buffer.length * 2 + chars.length));
            this.capacity = this.buffer.length;
        }
        Chr._idx((char[])this.buffer, (int)this.location, (char[])chars);
        this.location += chars.length;
        return this;
    }

    public final CharBuf addChars(char[] chars) {
        if (chars.length + this.location > this.capacity) {
            this.buffer = Chr.grow((char[])this.buffer, (int)(this.buffer.length * 2 + chars.length));
            this.capacity = this.buffer.length;
        }
        System.arraycopy(chars, 0, this.buffer, this.location, chars.length);
        this.location += chars.length;
        return this;
    }

    public final CharBuf addQuoted(char[] chars) {
        int _location = this.location;
        char[] _buffer = this.buffer;
        int sizeNeeded = chars.length + 2 + _location;
        int _capacity = this.capacity;
        if (sizeNeeded > _capacity) {
            _buffer = Chr.grow((char[])_buffer, (int)(sizeNeeded * 2));
            _capacity = _buffer.length;
        }
        _buffer[_location] = 34;
        System.arraycopy(chars, 0, _buffer, ++_location, chars.length);
        _buffer[_location += chars.length] = 34;
        this.location = ++_location;
        this.buffer = _buffer;
        this.capacity = _capacity;
        return this;
    }

    public final CharBuf addJsonEscapedString(String jsonString) {
        return this.addJsonEscapedString(jsonString, false);
    }

    public final CharBuf addJsonEscapedString(String jsonString, boolean disableUnicodeEscaping) {
        char[] charArray = FastStringUtils.toCharArray((String)jsonString);
        return this.addJsonEscapedString(charArray, disableUnicodeEscaping);
    }

    private static boolean shouldEscape(int c, boolean disableUnicodeEscaping) {
        if (c < 32) {
            return true;
        }
        if (c == 34) {
            return true;
        }
        if (c == 92) {
            return true;
        }
        return !disableUnicodeEscaping && c > 126;
    }

    private static boolean hasAnyJSONControlChars(char[] charArray, boolean disableUnicodeEscaping) {
        int index = 0;
        do {
            char c;
            if (!CharBuf.shouldEscape(c = charArray[index], disableUnicodeEscaping)) continue;
            return true;
        } while (++index < charArray.length);
        return false;
    }

    public final CharBuf addJsonEscapedString(char[] charArray) {
        return this.addJsonEscapedString(charArray, false);
    }

    public final CharBuf addJsonEscapedString(char[] charArray, boolean disableUnicodeEscaping) {
        if (charArray.length == 0) {
            return this;
        }
        if (CharBuf.hasAnyJSONControlChars(charArray, disableUnicodeEscaping)) {
            return this.doAddJsonEscapedString(charArray, disableUnicodeEscaping);
        }
        return this.addQuoted(charArray);
    }

    private CharBuf doAddJsonEscapedString(char[] charArray, boolean disableUnicodeEscaping) {
        char[] _buffer = this.buffer;
        int _location = this.location;
        byte[] _encoded = this.encoded;
        byte[] _charTo = this.charTo;
        int ensureThisMuch = charArray.length * 6 + 2;
        int sizeNeeded = ensureThisMuch + _location;
        if (sizeNeeded > this.capacity) {
            int growBy = _buffer.length * 2 < sizeNeeded ? sizeNeeded : _buffer.length * 2;
            _buffer = Chr.grow((char[])this.buffer, (int)growBy);
            this.capacity = _buffer.length;
        }
        _buffer[_location] = 34;
        ++_location;
        int index = 0;
        do {
            char c;
            if (CharBuf.shouldEscape(c = charArray[index], disableUnicodeEscaping)) {
                if (_location + 5 > _buffer.length) {
                    _buffer = Chr.grow((char[])_buffer, (int)20);
                }
                switch (c) {
                    case '\"': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 34;
                        ++_location;
                        break;
                    }
                    case '\\': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 92;
                        ++_location;
                        break;
                    }
                    case '\b': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 98;
                        ++_location;
                        break;
                    }
                    case '\f': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 102;
                        ++_location;
                        break;
                    }
                    case '\n': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 110;
                        ++_location;
                        break;
                    }
                    case '\r': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 114;
                        ++_location;
                        break;
                    }
                    case '\t': {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 116;
                        ++_location;
                        break;
                    }
                    default: {
                        _buffer[_location] = 92;
                        _buffer[++_location] = 117;
                        ++_location;
                        if (c <= '\u00ff') {
                            _buffer[_location] = 48;
                            _buffer[++_location] = 48;
                            ++_location;
                            ByteScanner.encodeByteIntoTwoAsciiCharBytes((int)c, (byte[])_encoded);
                            for (byte b : _encoded) {
                                _buffer[_location] = (char)b;
                                ++_location;
                            }
                        } else {
                            _charTo[1] = (byte)c;
                            _charTo[0] = (byte)(c >>> 8);
                            for (byte charByte : _charTo) {
                                ByteScanner.encodeByteIntoTwoAsciiCharBytes((int)charByte, (byte[])_encoded);
                                for (byte b : _encoded) {
                                    _buffer[_location] = (char)b;
                                    ++_location;
                                }
                            }
                        }
                    }
                }
                continue;
            }
            _buffer[_location] = c;
            ++_location;
        } while (++index < charArray.length);
        _buffer[_location] = 34;
        this.buffer = _buffer;
        this.location = ++_location;
        return this;
    }

    public final CharBuf addJsonFieldName(String str) {
        return this.addJsonFieldName(str, false);
    }

    public final CharBuf addJsonFieldName(String str, boolean disableUnicodeEscaping) {
        return this.addJsonFieldName(FastStringUtils.toCharArray((String)str), disableUnicodeEscaping);
    }

    public final CharBuf addJsonFieldName(char[] chars) {
        return this.addJsonFieldName(chars, false);
    }

    public final CharBuf addJsonFieldName(char[] chars, boolean disableUnicodeEscaping) {
        if (chars.length > 0) {
            this.addJsonEscapedString(chars, disableUnicodeEscaping);
        } else {
            this.addChars(EMPTY_STRING_CHARS);
        }
        this.addChar(':');
        return this;
    }

    public final CharBuf addQuoted(String str) {
        char[] chars = FastStringUtils.toCharArray((String)str);
        this.addQuoted(chars);
        return this;
    }

    public CharBuf add(char[] chars, int length) {
        if (length + this.location < this.capacity) {
            Chr._idx((char[])this.buffer, (int)this.location, (char[])chars, (int)length);
        } else {
            this.buffer = Chr.grow((char[])this.buffer, (int)(this.buffer.length * 2 + length));
            Chr._idx((char[])this.buffer, (int)this.location, (char[])chars);
            this.capacity = this.buffer.length;
        }
        this.location += length;
        return this;
    }

    public CharBuf add(byte[] chars) {
        if (chars.length + this.location < this.capacity) {
            Chr._idx((char[])this.buffer, (int)this.location, (byte[])chars);
        } else {
            this.buffer = Chr.grow((char[])this.buffer, (int)(this.buffer.length * 2 + chars.length));
            Chr._idx((char[])this.buffer, (int)this.location, (byte[])chars);
            this.capacity = this.buffer.length;
        }
        this.location += chars.length;
        return this;
    }

    public CharBuf add(byte[] bytes, int start, int end) {
        int charsLength = end - start;
        if (charsLength + this.location > this.capacity) {
            this.buffer = Chr.grow((char[])this.buffer, (int)(this.buffer.length * 2 + charsLength));
        }
        Chr._idx((char[])this.buffer, (int)this.location, (byte[])bytes, (int)start, (int)end);
        this.capacity = this.buffer.length;
        this.location += charsLength;
        return this;
    }

    public final CharBuf add(char ch) {
        if (1 + this.location < this.capacity) {
            this.buffer[this.location] = ch;
        } else {
            this.buffer = Chr.grow((char[])this.buffer);
            this.buffer[this.location] = ch;
            this.capacity = this.buffer.length;
        }
        ++this.location;
        return this;
    }

    @Override
    public int length() {
        return this.len();
    }

    @Override
    public char charAt(int index) {
        return this.buffer[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new String(this.buffer, start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.location);
    }

    public String toDebugString() {
        return "CharBuf{capacity=" + this.capacity + ", location=" + this.location + '}';
    }

    public String toStringAndRecycle() {
        String str = new String(this.buffer, 0, this.location);
        this.location = 0;
        return str;
    }

    public int len() {
        return this.location;
    }

    public char[] toCharArray() {
        return this.buffer;
    }

    public void _len(int location) {
        this.location = location;
    }

    public char[] readForRecycle() {
        this.location = 0;
        return this.buffer;
    }

    public void recycle() {
        this.location = 0;
    }

    public double doubleValue() {
        return CharScanner.parseDouble((char[])this.buffer, (int)0, (int)this.location);
    }

    public float floatValue() {
        return CharScanner.parseFloat((char[])this.buffer, (int)0, (int)this.location);
    }

    public int intValue() {
        return CharScanner.parseIntFromTo((char[])this.buffer, (int)0, (int)this.location);
    }

    public long longValue() {
        return CharScanner.parseLongFromTo((char[])this.buffer, (int)0, (int)this.location);
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public short shortValue() {
        return (short)this.intValue();
    }

    public Number toIntegerWrapper() {
        if (CharScanner.isInteger((char[])this.buffer, (int)0, (int)this.location)) {
            return this.intValue();
        }
        return this.longValue();
    }

    public final void addNull() {
        this.add(nullChars);
    }

    public void removeLastChar() {
        if (this.location > 0) {
            --this.location;
        }
    }

    public void removeLastChar(char expect) {
        if (this.location == 0 || this.buffer[this.location - 1] != expect) {
            return;
        }
        this.removeLastChar();
    }

    public CharBuf addBigDecimal(BigDecimal key) {
        char[] chars;
        if (this.bigDCache == null) {
            this.bigDCache = new SimpleCache(20, CacheType.LRU);
        }
        if ((chars = (char[])this.bigDCache.get((Object)key)) == null) {
            String str = key.toString();
            chars = FastStringUtils.toCharArray((String)str);
            this.bigDCache.put((Object)key, (Object)chars);
        }
        this.add(chars);
        return this;
    }

    public CharBuf addBigInteger(BigInteger key) {
        char[] chars;
        if (this.bigICache == null) {
            this.bigICache = new SimpleCache(20, CacheType.LRU);
        }
        if ((chars = (char[])this.bigICache.get((Object)key)) == null) {
            String str = key.toString();
            chars = FastStringUtils.toCharArray((String)str);
            this.bigICache.put((Object)key, (Object)chars);
        }
        this.add(chars);
        return this;
    }

    public final CharBuf addLong(long l) {
        this.addLong((Long)l);
        return this;
    }

    public final CharBuf addLong(Long key) {
        char[] chars;
        if (this.lcache == null) {
            this.lcache = new SimpleCache(20, CacheType.LRU);
        }
        if ((chars = (char[])this.lcache.get((Object)key)) == null) {
            String str = Long.toString(key);
            chars = FastStringUtils.toCharArray((String)str);
            this.lcache.put((Object)key, (Object)chars);
        }
        this.add(chars);
        return this;
    }

    public final CharBuf decodeJsonString(char[] chars) {
        return this.decodeJsonString(chars, 0, chars.length);
    }

    public final CharBuf decodeJsonString(char[] chars, int start, int to) {
        int len = to - start;
        char[] buffer = this.buffer;
        int location = this.location;
        if (len > this.capacity) {
            buffer = Chr.grow((char[])buffer, (int)(buffer.length * 2 + len));
            this.capacity = buffer.length;
        }
        block11: for (int index = start; index < to; ++index) {
            char c = chars[index];
            if (c == '\\') {
                if (index >= to) continue;
                c = chars[++index];
                switch (c) {
                    case 'n': {
                        buffer[location++] = 10;
                        continue block11;
                    }
                    case '/': {
                        buffer[location++] = 47;
                        continue block11;
                    }
                    case '\"': {
                        buffer[location++] = 34;
                        continue block11;
                    }
                    case 'f': {
                        buffer[location++] = 12;
                        continue block11;
                    }
                    case 't': {
                        buffer[location++] = 9;
                        continue block11;
                    }
                    case '\\': {
                        buffer[location++] = 92;
                        continue block11;
                    }
                    case 'b': {
                        buffer[location++] = 8;
                        continue block11;
                    }
                    case 'r': {
                        buffer[location++] = 13;
                        continue block11;
                    }
                    case 'u': {
                        if (index + 4 >= to) continue block11;
                        String hex = new String(chars, index + 1, 4);
                        char unicode = (char)Integer.parseInt(hex, 16);
                        buffer[location++] = unicode;
                        index += 4;
                        continue block11;
                    }
                    default: {
                        throw new JsonException("Unable to decode string");
                    }
                }
            }
            buffer[location++] = c;
        }
        this.buffer = buffer;
        this.location = location;
        return this;
    }
}

