/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.toc.Toc;
import org.docx4j.toc.TocException;
import org.docx4j.toc.TocStyles;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTSdtDocPart;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtContentBlock;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TocSdtUtils {
    private static Logger log = LoggerFactory.getLogger(TocSdtUtils.class);
    private static final String PRESERVE = "preserve";
    private static ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();
    private static String XML_TOCHeading_BasedOn_Nothing = "<w:style w:styleId=\"TOCHeading\" w:type=\"paragraph\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:name w:val=\"TOC Heading\"/><w:next w:val=\"Normal\"/><w:uiPriority w:val=\"39\"/><w:semiHidden/><w:unhideWhenUsed/><w:qFormat/><w:pPr><w:keepNext/><w:keepLines/><w:spacing w:after=\"0\" w:before=\"480\"/><w:outlineLvl w:val=\"9\"/></w:pPr><w:rPr><w:rFonts w:asciiTheme=\"majorHAnsi\" w:cstheme=\"majorBidi\" w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"/><w:b/><w:bCs/><w:color w:themeColor=\"accent1\" w:themeShade=\"BF\" w:val=\"365F91\"/><w:sz w:val=\"28\"/><w:szCs w:val=\"28\"/></w:rPr></w:style>";
    private static String XML_TOCHeading_BasedOn_Heading1 = "<w:style w:styleId=\"TOCHeading\" w:type=\"paragraph\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:name w:val=\"TOC Heading\"/><w:basedOn w:val=\"Heading1\"/><w:next w:val=\"Normal\"/><w:uiPriority w:val=\"39\"/><w:semiHidden/><w:unhideWhenUsed/><w:qFormat/><w:pPr><w:outlineLvl w:val=\"9\"/></w:pPr></w:style>";

    public static SdtBlock createSdt() {
        ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();
        SdtBlock sdtBlock = wmlObjectFactory.createSdtBlock();
        SdtPr sdtpr = wmlObjectFactory.createSdtPr();
        CTSdtDocPart sdtdocpart = wmlObjectFactory.createCTSdtDocPart();
        JAXBElement sdtdocpartWrapped = wmlObjectFactory.createSdtPrDocPartObj(sdtdocpart);
        sdtpr.getRPrOrAliasOrLock().add(sdtdocpartWrapped);
        CTSdtDocPart.DocPartGallery sdtdocpartdocpartgallery = wmlObjectFactory.createCTSdtDocPartDocPartGallery();
        sdtdocpart.setDocPartGallery(sdtdocpartdocpartgallery);
        sdtdocpartdocpartgallery.setVal("Table of Contents");
        BooleanDefaultTrue booleandefaulttrue = wmlObjectFactory.createBooleanDefaultTrue();
        sdtdocpart.setDocPartUnique(booleandefaulttrue);
        sdtpr.setId();
        sdtBlock.setSdtPr(sdtpr);
        return sdtBlock;
    }

    public static SdtContentBlock createSdtContent() {
        return Context.getWmlObjectFactory().createSdtContentBlock();
    }

    public static void addTocHeading(MainDocumentPart documentPart, TocStyles tocStyles, SdtContentBlock sdtContent) throws TocException {
        TocSdtUtils.addTocHeading(documentPart, tocStyles, sdtContent, Toc.DEFAULT_TOC_HEADING);
    }

    public static void addTocHeading(MainDocumentPart documentPart, TocStyles tocStyles, SdtContentBlock sdtContent, String tocHeading) throws TocException {
        String TOC_HEADING_STYLE = tocStyles.getStyleIdForName("TOC Heading");
        if (TOC_HEADING_STYLE == null) {
            log.warn("No definition found for TOC Heading style");
            String HEADING1_STYLE = tocStyles.getStyleIdForName("heading 1");
            try {
                if (TOC_HEADING_STYLE == null) {
                    if (HEADING1_STYLE == null) {
                        Style style = (Style)XmlUtils.unmarshalString(XML_TOCHeading_BasedOn_Nothing);
                        style.getBasedOn().setVal(HEADING1_STYLE);
                        ((Styles)documentPart.getStyleDefinitionsPart().getContents()).getStyle().add(style);
                    } else {
                        Style style = (Style)XmlUtils.unmarshalString(XML_TOCHeading_BasedOn_Heading1);
                        style.getBasedOn().setVal(HEADING1_STYLE);
                        ((Styles)documentPart.getStyleDefinitionsPart().getContents()).getStyle().add(style);
                    }
                    TOC_HEADING_STYLE = "TOCHeading";
                }
            }
            catch (Exception e) {
                throw new TocException(e.getMessage(), e);
            }
        }
        sdtContent.getContent().add(TocSdtUtils.generateTocHeading(TOC_HEADING_STYLE, tocHeading));
    }

    public static List<R> getTocInstruction(String tocInstruction) {
        ArrayList<R> fieldRs = new ArrayList<R>();
        R r2 = wmlObjectFactory.createR();
        fieldRs.add(r2);
        FldChar fldchar = wmlObjectFactory.createFldChar();
        JAXBElement fldcharWrapped = wmlObjectFactory.createRFldChar(fldchar);
        r2.getContent().add(fldcharWrapped);
        fldchar.setFldCharType(STFldCharType.BEGIN);
        R r3 = wmlObjectFactory.createR();
        fieldRs.add(r3);
        Text text2 = wmlObjectFactory.createText();
        JAXBElement textWrapped2 = wmlObjectFactory.createRInstrText(text2);
        r3.getContent().add(textWrapped2);
        text2.setValue(tocInstruction);
        text2.setSpace(PRESERVE);
        R r4 = wmlObjectFactory.createR();
        fieldRs.add(r4);
        FldChar fldchar2 = wmlObjectFactory.createFldChar();
        JAXBElement fldcharWrapped2 = wmlObjectFactory.createRFldChar(fldchar2);
        r4.getContent().add(fldcharWrapped2);
        fldchar2.setFldCharType(STFldCharType.SEPARATE);
        return fieldRs;
    }

    static P generateTocHeading(String headingStyleId) {
        return TocSdtUtils.generateTocHeading(headingStyleId, Toc.DEFAULT_TOC_HEADING);
    }

    private static P generateTocHeading(String headingStyleId, String tocHeading) {
        P p = wmlObjectFactory.createP();
        PPr ppr = wmlObjectFactory.createPPr();
        p.setPPr(ppr);
        PPrBase.PStyle pprbasepstyle = wmlObjectFactory.createPPrBasePStyle();
        ppr.setPStyle(pprbasepstyle);
        pprbasepstyle.setVal(headingStyleId);
        R r = wmlObjectFactory.createR();
        p.getContent().add(r);
        Text text = wmlObjectFactory.createText();
        JAXBElement textWrapped = wmlObjectFactory.createRT(text);
        r.getContent().add(textWrapped);
        text.setValue(tocHeading);
        return p;
    }

    public static P getLastParagraph() {
        P p = wmlObjectFactory.createP();
        R r2 = wmlObjectFactory.createR();
        p.getContent().add(r2);
        FldChar fldchar = wmlObjectFactory.createFldChar();
        JAXBElement fldcharWrapped = wmlObjectFactory.createRFldChar(fldchar);
        r2.getContent().add(fldcharWrapped);
        fldchar.setFldCharType(STFldCharType.END);
        return p;
    }
}

