/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.fop.tools;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.org.apache.fop.events.EventProducer;
import org.docx4j.org.apache.fop.events.model.EventMethodModel;
import org.docx4j.org.apache.fop.events.model.EventModel;
import org.docx4j.org.apache.fop.events.model.EventProducerModel;
import org.docx4j.org.apache.fop.events.model.EventSeverity;
import org.docx4j.org.apache.fop.tools.EventConventionException;

class EventProducerCollector {
    private static final String CLASSNAME_EVENT_PRODUCER = EventProducer.class.getName();
    private static final Map<String, Class<?>> PRIMITIVE_MAP;
    private DocletTagFactory tagFactory;
    private List<EventModel> models = new ArrayList<EventModel>();

    EventProducerCollector() {
        this.tagFactory = this.createDocletTagFactory();
    }

    protected DocletTagFactory createDocletTagFactory() {
        return new DefaultDocletTagFactory();
    }

    public boolean scanFile(File src) throws IOException, EventConventionException, ClassNotFoundException {
        JavaDocBuilder builder = new JavaDocBuilder(this.tagFactory);
        builder.addSource(src);
        JavaClass[] classes = builder.getClasses();
        boolean eventProducerFound = false;
        for (JavaClass clazz : classes) {
            if (!clazz.isInterface() || !this.implementsInterface(clazz, CLASSNAME_EVENT_PRODUCER)) continue;
            this.processEventProducerInterface(clazz);
            eventProducerFound = true;
        }
        return eventProducerFound;
    }

    private boolean implementsInterface(JavaClass clazz, String intf) {
        JavaClass[] classes;
        for (JavaClass cl : classes = clazz.getImplementedInterfaces()) {
            if (!cl.getFullyQualifiedName().equals(intf)) continue;
            return true;
        }
        return false;
    }

    protected void processEventProducerInterface(JavaClass clazz) throws EventConventionException, ClassNotFoundException {
        JavaMethod[] methods;
        EventProducerModel prodMeta = new EventProducerModel(clazz.getFullyQualifiedName());
        for (JavaMethod method : methods = clazz.getMethods(true)) {
            EventMethodModel methodMeta = this.createMethodModel(method);
            prodMeta.addMethod(methodMeta);
        }
        EventModel model = new EventModel();
        model.addProducer(prodMeta);
        this.models.add(model);
    }

    private EventMethodModel createMethodModel(JavaMethod method) throws EventConventionException, ClassNotFoundException {
        Type[] exceptions;
        JavaClass clazz = method.getParentClass();
        if (!method.getReturnType().isVoid()) {
            throw new EventConventionException("All methods of interface " + clazz.getFullyQualifiedName() + " must have return type 'void'!");
        }
        String methodSig = clazz.getFullyQualifiedName() + "." + method.getCallSignature();
        JavaParameter[] params = method.getParameters();
        if (params.length < 1) {
            throw new EventConventionException("The method " + methodSig + " must have at least one parameter: 'Object source'!");
        }
        Type firstType = params[0].getType();
        if (firstType.isPrimitive() || !"source".equals(params[0].getName())) {
            throw new EventConventionException("The first parameter of the method " + methodSig + " must be: 'Object source'!");
        }
        DocletTag tag = method.getTagByName("event.severity");
        EventSeverity severity = tag != null ? EventSeverity.valueOf(tag.getValue()) : EventSeverity.INFO;
        EventMethodModel methodMeta = new EventMethodModel(method.getName(), severity);
        if (params.length > 1) {
            int cj = params.length;
            for (int j = 1; j < cj; ++j) {
                Class<?> type;
                JavaParameter p = params[j];
                JavaClass pClass = p.getType().getJavaClass();
                if (p.getType().isPrimitive()) {
                    type = PRIMITIVE_MAP.get(pClass.getName());
                    if (type == null) {
                        throw new UnsupportedOperationException("Primitive datatype not supported: " + pClass.getName());
                    }
                } else {
                    String className = pClass.getFullyQualifiedName();
                    type = Class.forName(className);
                }
                methodMeta.addParameter(type, p.getName());
            }
        }
        if ((exceptions = method.getExceptions()) != null && exceptions.length > 0) {
            JavaClass cl = exceptions[0].getJavaClass();
            methodMeta.setExceptionClass(cl.getFullyQualifiedName());
            methodMeta.setSeverity(EventSeverity.FATAL);
        }
        return methodMeta;
    }

    public List<EventModel> getModels() {
        return this.models;
    }

    static {
        HashMap<String, Class> m = new HashMap<String, Class>();
        m.put("boolean", Boolean.class);
        m.put("byte", Byte.class);
        m.put("char", Character.class);
        m.put("short", Short.class);
        m.put("int", Integer.class);
        m.put("long", Long.class);
        m.put("float", Float.class);
        m.put("double", Double.class);
        PRIMITIVE_MAP = Collections.unmodifiableMap(m);
    }
}

