/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send.gssapi;

import com.sun.jna.platform.win32.Sspi;
import java.io.IOException;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.send.gssapi.GssapiAuth;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class WindowsNativeSspiAuthentication
extends GssapiAuth {
    public WindowsNativeSspiAuthentication(ReadPacketFetcher packetFetcher, int packSeq) {
        super(packetFetcher, packSeq);
    }

    @Override
    public void authenticate(PacketOutputStream writer, String serverPrincipalName, String mechanisms) throws QueryException, IOException {
        IWindowsSecurityContext clientContext = WindowsSecurityContextImpl.getCurrent((String)mechanisms, (String)serverPrincipalName);
        do {
            byte[] tokenForTheServerOnTheClient = clientContext.getToken();
            writer.startPacket(this.packSeq);
            writer.write(tokenForTheServerOnTheClient);
            writer.finishPacketWithoutRelease(false);
            writer.releaseBuffer();
            if (!clientContext.isContinue()) continue;
            Buffer buffer = this.packetFetcher.getReusableBuffer();
            this.packSeq = this.packetFetcher.getLastPacketSeq() + 1;
            byte[] tokenForTheClientOnTheServer = buffer.readRawBytes(buffer.remaining());
            Sspi.SecBufferDesc continueToken = new Sspi.SecBufferDesc(2, tokenForTheClientOnTheServer);
            clientContext.initialize(clientContext.getHandle(), continueToken, serverPrincipalName);
        } while (clientContext.isContinue());
        clientContext.dispose();
    }
}

