/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.web.GsonHttpMessageConvertersConfiguration;
import org.springframework.boot.autoconfigure.web.HttpEncodingProperties;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.JacksonHttpMessageConvertersConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;

@Configuration
@ConditionalOnClass(value={HttpMessageConverter.class})
@AutoConfigureAfter(value={GsonAutoConfiguration.class, JacksonAutoConfiguration.class})
@Import(value={JacksonHttpMessageConvertersConfiguration.class, GsonHttpMessageConvertersConfiguration.class})
public class HttpMessageConvertersAutoConfiguration {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.http.converters.preferred-json-mapper";
    private final List<HttpMessageConverter<?>> converters;

    public HttpMessageConvertersAutoConfiguration(ObjectProvider<List<HttpMessageConverter<?>>> convertersProvider) {
        this.converters = (List)convertersProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters messageConverters() {
        return new HttpMessageConverters(this.converters != null ? this.converters : Collections.emptyList());
    }

    @Configuration
    @ConditionalOnClass(value={StringHttpMessageConverter.class})
    @EnableConfigurationProperties(value={HttpEncodingProperties.class})
    protected static class StringHttpMessageConverterConfiguration {
        private final HttpEncodingProperties encodingProperties;

        protected StringHttpMessageConverterConfiguration(HttpEncodingProperties encodingProperties) {
            this.encodingProperties = encodingProperties;
        }

        @Bean
        @ConditionalOnMissingBean
        public StringHttpMessageConverter stringHttpMessageConverter() {
            StringHttpMessageConverter converter = new StringHttpMessageConverter(this.encodingProperties.getCharset());
            converter.setWriteAcceptCharset(false);
            return converter;
        }
    }
}

