/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;

public class PackageBodySnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    public PackageBodySnapshotGenerator() {
        super(DatabasePackageBody.class, new Class[]{Schema.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        try {
            if (database instanceof Db2zDatabase || database instanceof DB2Database && database.getDatabaseMajorVersion() == 9) {
                return -1;
            }
        }
        catch (DatabaseException databaseException) {}
        if (database instanceof OracleDatabase || database instanceof DB2Database) {
            return super.getPriority(clazz, database);
        }
        return -1;
    }

    @Override
    protected String getObjectType(Database database) {
        return "PACKAGE BODY";
    }

    protected StoredDatabaseLogic<DatabasePackageBody> createReturnObject() {
        return new DatabasePackageBody();
    }

    @Override
    protected String getSnapshotObjectSql(StoredDatabaseLogic<?> storedDatabaseLogic, Database database) {
        if (database instanceof DB2Database) {
            return "select NAME AS OBJECT_NAME, NULL AS CREATED, NULL AS LAST_MODIFIED, 'VALID' as STATUS, TEXT AS OBJECT_BODY from ALL_SOURCE where type='" + this.getObjectType(database) + "' and name='" + database.correctObjectName(storedDatabaseLogic.getName(), StoredDatabaseLogic.class) + "' and schema='" + database.correctObjectName(storedDatabaseLogic.getSchema().getCatalogName(), Catalog.class) + "'";
        }
        return super.getSnapshotObjectSql(storedDatabaseLogic, database);
    }

    @Override
    protected String getAddToSql(Schema schema, Database database) {
        if (database instanceof DB2Database) {
            return "SELECT NAME AS OBJECT_NAME FROM ALL_SOURCE WHERE TYPE='" + this.getObjectType(database) + "' AND SCHEMA='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "'";
        }
        return super.getAddToSql(schema, database);
    }
}

