/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.sql;

import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class SQLDataProvider
extends HashMap<String, Object> {
    private static final long serialVersionUID = 6237301616073252200L;

    public SQLDataProvider(ResultSet rs, FieldsMetadata metadata) throws SQLException {
        HashMap<String, Object> pojoItem = null;
        while (rs.next()) {
            pojoItem = null;
            int columnCount = this.getColumnCount(rs);
            String tableName = null;
            String columnLabel = null;
            for (int columnIndex = 1; columnIndex < columnCount + 1; ++columnIndex) {
                tableName = this.getTableName(rs, columnIndex);
                String listName = this.getListName(tableName, columnLabel = this.getColumnLabel(rs, columnIndex));
                if (listName != null) {
                    ArrayList list = (ArrayList)super.get(listName);
                    if (list == null) {
                        list = new ArrayList();
                        super.put(listName, list);
                    }
                    if (pojoItem == null) {
                        pojoItem = new HashMap<String, Object>();
                        list.add(pojoItem);
                    }
                    String getterName = columnLabel;
                    boolean sameListName = listName.equals(tableName);
                    if (!sameListName) {
                        getterName = tableName + "_" + columnLabel;
                    }
                    pojoItem.put(getterName, rs.getObject(columnIndex));
                    String fieldName = listName + "." + getterName;
                    metadata.addFieldAsList(fieldName);
                    if (sameListName) continue;
                    metadata.addFieldReplacement(tableName + "." + columnLabel, fieldName);
                    continue;
                }
                HashMap<String, Object> pojo = (HashMap<String, Object>)super.get(tableName);
                if (pojo == null) {
                    pojo = new HashMap<String, Object>();
                    super.put(tableName, pojo);
                }
                metadata.addField(tableName + "." + columnLabel, null, null, null, null);
                pojo.put(columnLabel, rs.getObject(columnIndex));
            }
        }
    }

    protected int getColumnCount(ResultSet rs) throws SQLException {
        return rs.getMetaData().getColumnCount();
    }

    protected String getTableName(ResultSet rs, int column) throws SQLException {
        return rs.getMetaData().getTableName(column);
    }

    protected String getColumnLabel(ResultSet rs, int column) throws SQLException {
        return rs.getMetaData().getColumnLabel(column);
    }

    protected abstract String getListName(String var1, String var2);
}

