/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.DecodeHintType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;

public final class StringUtils {
    private static final Charset PLATFORM_DEFAULT_ENCODING;
    public static final Charset SHIFT_JIS_CHARSET;
    public static final Charset GB2312_CHARSET;
    private static final Charset EUC_JP;
    private static final boolean ASSUME_SHIFT_JIS;
    public static final String SHIFT_JIS = "SJIS";
    public static final String GB2312 = "GB2312";

    private StringUtils() {
    }

    public static String guessEncoding(byte[] bytes, Map<DecodeHintType, ?> hints) {
        Charset c = StringUtils.guessCharset(bytes, hints);
        if (c.equals(SHIFT_JIS_CHARSET)) {
            return SHIFT_JIS;
        }
        if (c.equals(StandardCharsets.UTF_8)) {
            return "UTF8";
        }
        if (c.equals(StandardCharsets.ISO_8859_1)) {
            return "ISO8859_1";
        }
        return c.name();
    }

    public static Charset guessCharset(byte[] bytes, Map<DecodeHintType, ?> hints) {
        if (hints != null && hints.containsKey((Object)DecodeHintType.CHARACTER_SET)) {
            return Charset.forName(hints.get((Object)DecodeHintType.CHARACTER_SET).toString());
        }
        if (bytes.length > 2 && (bytes[0] == -2 && bytes[1] == -1 || bytes[0] == -1 && bytes[1] == -2)) {
            return StandardCharsets.UTF_16;
        }
        int length = bytes.length;
        boolean canBeISO88591 = true;
        boolean canBeShiftJIS = true;
        boolean canBeUTF8 = true;
        int utf8BytesLeft = 0;
        int utf2BytesChars = 0;
        int utf3BytesChars = 0;
        int utf4BytesChars = 0;
        int sjisBytesLeft = 0;
        int sjisKatakanaChars = 0;
        int sjisCurKatakanaWordLength = 0;
        int sjisCurDoubleBytesWordLength = 0;
        int sjisMaxKatakanaWordLength = 0;
        int sjisMaxDoubleBytesWordLength = 0;
        int isoHighOther = 0;
        boolean utf8bom = bytes.length > 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65;
        for (int i = 0; i < length && (canBeISO88591 || canBeShiftJIS || canBeUTF8); ++i) {
            int value = bytes[i] & 0xFF;
            if (canBeUTF8) {
                if (utf8BytesLeft > 0) {
                    if ((value & 0x80) == 0) {
                        canBeUTF8 = false;
                    } else {
                        --utf8BytesLeft;
                    }
                } else if ((value & 0x80) != 0) {
                    if ((value & 0x40) == 0) {
                        canBeUTF8 = false;
                    } else {
                        ++utf8BytesLeft;
                        if ((value & 0x20) == 0) {
                            ++utf2BytesChars;
                        } else {
                            ++utf8BytesLeft;
                            if ((value & 0x10) == 0) {
                                ++utf3BytesChars;
                            } else {
                                ++utf8BytesLeft;
                                if ((value & 8) == 0) {
                                    ++utf4BytesChars;
                                } else {
                                    canBeUTF8 = false;
                                }
                            }
                        }
                    }
                }
            }
            if (canBeISO88591) {
                if (value > 127 && value < 160) {
                    canBeISO88591 = false;
                } else if (value > 159 && (value < 192 || value == 215 || value == 247)) {
                    ++isoHighOther;
                }
            }
            if (!canBeShiftJIS) continue;
            if (sjisBytesLeft > 0) {
                if (value < 64 || value == 127 || value > 252) {
                    canBeShiftJIS = false;
                    continue;
                }
                --sjisBytesLeft;
                continue;
            }
            if (value == 128 || value == 160 || value > 239) {
                canBeShiftJIS = false;
                continue;
            }
            if (value > 160 && value < 224) {
                ++sjisKatakanaChars;
                sjisCurDoubleBytesWordLength = 0;
                if (++sjisCurKatakanaWordLength <= sjisMaxKatakanaWordLength) continue;
                sjisMaxKatakanaWordLength = sjisCurKatakanaWordLength;
                continue;
            }
            if (value > 127) {
                ++sjisBytesLeft;
                sjisCurKatakanaWordLength = 0;
                if (++sjisCurDoubleBytesWordLength <= sjisMaxDoubleBytesWordLength) continue;
                sjisMaxDoubleBytesWordLength = sjisCurDoubleBytesWordLength;
                continue;
            }
            sjisCurKatakanaWordLength = 0;
            sjisCurDoubleBytesWordLength = 0;
        }
        if (canBeUTF8 && utf8BytesLeft > 0) {
            canBeUTF8 = false;
        }
        if (canBeShiftJIS && sjisBytesLeft > 0) {
            canBeShiftJIS = false;
        }
        if (canBeUTF8 && (utf8bom || utf2BytesChars + utf3BytesChars + utf4BytesChars > 0)) {
            return StandardCharsets.UTF_8;
        }
        if (canBeShiftJIS && (ASSUME_SHIFT_JIS || sjisMaxKatakanaWordLength >= 3 || sjisMaxDoubleBytesWordLength >= 3)) {
            return SHIFT_JIS_CHARSET;
        }
        if (canBeISO88591 && canBeShiftJIS) {
            return sjisMaxKatakanaWordLength == 2 && sjisKatakanaChars == 2 || isoHighOther * 10 >= length ? SHIFT_JIS_CHARSET : StandardCharsets.ISO_8859_1;
        }
        if (canBeISO88591) {
            return StandardCharsets.ISO_8859_1;
        }
        if (canBeShiftJIS) {
            return SHIFT_JIS_CHARSET;
        }
        if (canBeUTF8) {
            return StandardCharsets.UTF_8;
        }
        return PLATFORM_DEFAULT_ENCODING;
    }

    static {
        Charset gb2312Charset;
        PLATFORM_DEFAULT_ENCODING = Charset.defaultCharset();
        SHIFT_JIS_CHARSET = Charset.forName(SHIFT_JIS);
        try {
            gb2312Charset = Charset.forName(GB2312);
        }
        catch (UnsupportedCharsetException ucee) {
            gb2312Charset = null;
        }
        GB2312_CHARSET = gb2312Charset;
        EUC_JP = Charset.forName("EUC_JP");
        ASSUME_SHIFT_JIS = SHIFT_JIS_CHARSET.equals(PLATFORM_DEFAULT_ENCODING) || EUC_JP.equals(PLATFORM_DEFAULT_ENCODING);
    }
}

