/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class FastClass
implements Serializable {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private final Class type;

    public static FastClass create(Class type) {
        return new FastClass(type);
    }

    private FastClass(Class type) {
        this.type = type;
    }

    public Object invoke(String name, Class[] parameterTypes, Object obj, Object[] args) throws InvocationTargetException {
        return this.invoke(this.getIndex(name, parameterTypes), obj, args);
    }

    public Object invoke(int index, Object obj, Object[] args) throws InvocationTargetException {
        Method[] methods = this.type.getMethods();
        try {
            return methods[index].invoke(obj, args);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Cannot find matching method/constructor");
        }
        catch (IllegalAccessException e) {
            throw new InvocationTargetException(e);
        }
    }

    public Object newInstance() throws InvocationTargetException {
        return this.newInstance(this.getIndex(EMPTY_CLASS_ARRAY), null);
    }

    public Object newInstance(Class[] parameterTypes, Object[] args) throws InvocationTargetException {
        return this.newInstance(this.getIndex(parameterTypes), args);
    }

    public Object newInstance(int index, Object[] args) throws InvocationTargetException {
        Constructor<?>[] constructors = this.type.getConstructors();
        try {
            return constructors[index].newInstance(args);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Cannot find matching method/constructor");
        }
        catch (InstantiationException e) {
            throw new InvocationTargetException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationTargetException(e);
        }
    }

    public int getIndex(String name, Class[] parameterTypes) {
        Method[] methods = this.type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            if (!Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getName().equals(name) || (params = methods[i].getParameterTypes()).length != parameterTypes.length) continue;
            boolean eq = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j].equals(parameterTypes[j])) continue;
                eq = false;
                break;
            }
            if (!eq) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(Class[] parameterTypes) {
        Constructor<?>[] constructors = this.type.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] params;
            if (!Modifier.isPublic(constructors[i].getModifiers()) || (params = constructors[i].getParameterTypes()).length != parameterTypes.length) continue;
            boolean eq = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j].equals(parameterTypes[j])) continue;
                eq = false;
                break;
            }
            if (!eq) continue;
            return i;
        }
        return -1;
    }

    public String getName() {
        return this.type.getName();
    }

    public Class getJavaClass() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof FastClass && this.type.equals(((FastClass)o).type);
    }
}

