/*
 * Decompiled with CFR 0.152.
 */
package fr.w3blog.zpl.utils;

import fr.w3blog.zpl.constant.ZebraFont;
import fr.w3blog.zpl.constant.ZebraPPP;

public class ZplUtils {
    private static String variableObjectToZplCode(Object object) {
        if (object != null) {
            if (object instanceof Integer) {
                return Integer.toString((Integer)object);
            }
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return "Y";
                }
                return "N";
            }
            return object.toString();
        }
        return "";
    }

    public static StringBuilder zplCommand(String command) {
        StringBuilder zpl = new StringBuilder();
        zpl.append("^");
        zpl.append(command);
        return zpl;
    }

    public static StringBuilder zplCommandSautLigne(String command) {
        StringBuilder zpl = ZplUtils.zplCommand(command);
        zpl.append("\n");
        return zpl;
    }

    public static StringBuilder zplCommand(String command, Object ... variables) {
        StringBuilder zpl = new StringBuilder();
        zpl.append("^");
        zpl.append(command);
        if (variables.length > 1) {
            zpl.append(ZplUtils.variableObjectToZplCode(variables[0]));
            for (int i = 1; i < variables.length; ++i) {
                zpl.append(",");
                zpl.append(ZplUtils.variableObjectToZplCode(variables[i]));
            }
        } else if (variables.length == 1) {
            zpl.append(ZplUtils.variableObjectToZplCode(variables[0]));
        }
        return zpl;
    }

    public static StringBuilder zplCommandSautLigne(String command, Object ... variables) {
        StringBuilder zpl = ZplUtils.zplCommand(command, variables);
        zpl.append("\n");
        return zpl;
    }

    public static Integer[] extractDotsFromFont(ZebraFont zebraFont, int fontSize, ZebraPPP zebraPPP) {
        Integer[] array = new Integer[2];
        if (!ZebraFont.ZEBRA_ZERO.equals((Object)zebraFont) || !ZebraPPP.DPI_300.equals((Object)zebraPPP)) {
            throw new UnsupportedOperationException("This PPP and this font are not yet supported. Please use ZebraAFontElement.");
        }
        array[0] = Math.round((float)fontSize * 4.16f);
        array[1] = Math.round((float)fontSize * 4.06f);
        return array;
    }

    public static Integer convertPointInPixel(int point) {
        return Math.round((float)point * 1.33f);
    }

    public static String convertAccentToZplAsciiHexa(String str) {
        if (str != null) {
            str = str.replace("\u00e9", "\\82");
            str = str.replace("\u00e0", "\\85");
            str = str.replace("\u00e8", "\\8A");
        }
        return str;
    }
}

