/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.events.StoreEventSink;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.internal.util.ValueSuppliers;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.core.spi.store.tiering.LowerCachingTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.statistics.AuthoritativeTierOperationOutcomes;
import org.ehcache.core.statistics.LowerCachingTierOperationsOutcome;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.impl.internal.store.BinaryValueHolder;
import org.ehcache.impl.internal.store.offheap.BasicOffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.BinaryOffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.SwitchableEvictionAdvisor;
import org.ehcache.impl.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.observer.OperationObserver;

public abstract class AbstractOffHeapStore<K, V>
implements AuthoritativeTier<K, V>,
LowerCachingTier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOffHeapStore.class);
    private static final CachingTier.InvalidationListener<?, ?> NULL_INVALIDATION_LISTENER = new CachingTier.InvalidationListener<Object, Object>(){

        @Override
        public void onInvalidation(Object key, Store.ValueHolder<Object> valueHolder) {
        }
    };
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final TimeSource timeSource;
    private final StoreEventDispatcher<K, V> eventDispatcher;
    private final Expiry<? super K, ? super V> expiry;
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver;
    private final OperationObserver<StoreOperationOutcomes.ReplaceOutcome> replaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeOutcome> computeObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeIfAbsentOutcome> computeIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
    private final OperationObserver<StoreOperationOutcomes.ExpirationOutcome> expirationObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.GetAndFaultOutcome> getAndFaultObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome> computeIfAbsentAndFaultObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.FlushOutcome> flushObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.InvalidateOutcome> invalidateObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.InvalidateAllOutcome> invalidateAllObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.InvalidateAllWithHashOutcome> invalidateAllWithHashObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.GetAndRemoveOutcome> getAndRemoveObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.InstallMappingOutcome> installMappingObserver;
    private volatile AuthoritativeTier.InvalidationValve valve;
    protected BackingMapEvictionListener<K, V> mapEvictionListener;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener = NULL_INVALIDATION_LISTENER;
    private static final NullaryFunction<Boolean> REPLACE_EQUALS_TRUE = new NullaryFunction<Boolean>(){

        @Override
        public Boolean apply() {
            return Boolean.TRUE;
        }
    };

    public AbstractOffHeapStore(String statisticsTag, Store.Configuration<K, V> config, TimeSource timeSource, StoreEventDispatcher<K, V> eventDispatcher) {
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.expiry = config.getExpiry();
        this.timeSource = timeSource;
        this.eventDispatcher = eventDispatcher;
        this.getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).of(this)).named("get")).tag(statisticsTag)).build();
        this.putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).of(this)).named("put")).tag(statisticsTag)).build();
        this.putIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutIfAbsentOutcome.class).of(this)).named("putIfAbsent")).tag(statisticsTag)).build();
        this.removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).of(this)).named("remove")).tag(statisticsTag)).build();
        this.conditionalRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalRemoveOutcome.class).of(this)).named("conditionalRemove")).tag(statisticsTag)).build();
        this.replaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ReplaceOutcome.class).of(this)).named("replace")).tag(statisticsTag)).build();
        this.conditionalReplaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalReplaceOutcome.class).of(this)).named("conditionalReplace")).tag(statisticsTag)).build();
        this.computeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeOutcome.class).of(this)).named("compute")).tag(statisticsTag)).build();
        this.computeIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeIfAbsentOutcome.class).of(this)).named("computeIfAbsent")).tag(statisticsTag)).build();
        this.evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.EvictionOutcome.class).of(this)).named("eviction")).tag(statisticsTag)).build();
        this.expirationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ExpirationOutcome.class).of(this)).named("expiration")).tag(statisticsTag)).build();
        this.getAndFaultObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.class).of(this)).named("getAndFault")).tag(statisticsTag)).build();
        this.computeIfAbsentAndFaultObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.class).of(this)).named("computeIfAbsentAndFault")).tag(statisticsTag)).build();
        this.flushObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(AuthoritativeTierOperationOutcomes.FlushOutcome.class).of(this)).named("flush")).tag(statisticsTag)).build();
        this.invalidateObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(LowerCachingTierOperationsOutcome.InvalidateOutcome.class).of(this)).named("invalidate")).tag(statisticsTag)).build();
        this.invalidateAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(LowerCachingTierOperationsOutcome.InvalidateAllOutcome.class).of(this)).named("invalidateAll")).tag(statisticsTag)).build();
        this.invalidateAllWithHashObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(LowerCachingTierOperationsOutcome.InvalidateAllWithHashOutcome.class).of(this)).named("invalidateAllWithHash")).tag(statisticsTag)).build();
        this.getAndRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(LowerCachingTierOperationsOutcome.GetAndRemoveOutcome.class).of(this)).named("getAndRemove")).tag(statisticsTag)).build();
        this.installMappingObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(LowerCachingTierOperationsOutcome.InstallMappingOutcome.class).of(this)).named("installMapping")).tag(statisticsTag)).build();
        HashSet<String> tags = new HashSet<String>(Arrays.asList(statisticsTag, "tier"));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("discriminator", statisticsTag);
        StatisticsManager.createPassThroughStatistic(this, "allocatedMemory", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().allocatedMemory();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "occupiedMemory", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().occupiedMemory();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "dataAllocatedMemory", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().dataAllocatedMemory();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "dataOccupiedMemory", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().dataOccupiedMemory();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "dataSize", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().dataSize();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "dataVitalMemory", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().dataVitalMemory();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "mappings", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().longSize();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "maxMappings", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return -1L;
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "vitalMemory", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().vitalMemory();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "removedSlotCount", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().removedSlotCount();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "reprobeLength", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().reprobeLength();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "usedSlotCount", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().usedSlotCount();
            }
        });
        StatisticsManager.createPassThroughStatistic(this, "tableCapacity", tags, properties, new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return AbstractOffHeapStore.this.backingMap().tableCapacity();
            }
        });
        this.mapEvictionListener = new BackingMapEvictionListener(eventDispatcher, this.evictionObserver);
    }

    @Override
    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        this.checkKey(key);
        this.getObserver.begin();
        Store.ValueHolder<V> result = this.internalGet(key, true, true);
        if (result == null) {
            this.getObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
        } else {
            this.getObserver.end(StoreOperationOutcomes.GetOutcome.HIT);
        }
        return result;
    }

    private Store.ValueHolder<V> internalGet(K key, final boolean updateAccess, final boolean touchValue) throws StoreAccessException {
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        final AtomicReference heldValue = new AtomicReference();
        try {
            OffHeapValueHolder result = this.backingMap().computeIfPresent(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                @Override
                public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                    long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    if (updateAccess) {
                        mappedValue.forceDeserialization();
                        OffHeapValueHolder valueHolder = AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now, eventSink);
                        if (valueHolder == null) {
                            heldValue.set(mappedValue);
                        }
                        return valueHolder;
                    }
                    if (touchValue) {
                        mappedValue.forceDeserialization();
                    }
                    return mappedValue;
                }
            });
            if (result == null && heldValue.get() != null) {
                result = (OffHeapValueHolder)heldValue.get();
            }
            this.eventDispatcher.releaseEventSink(eventSink);
            return result;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            StorePassThroughException.handleRuntimeException(re);
            return null;
        }
    }

    @Override
    public boolean containsKey(K key) throws StoreAccessException {
        this.checkKey(key);
        return this.internalGet(key, false, false) != null;
    }

    @Override
    public Store.PutStatus put(final K key, final V value) throws StoreAccessException {
        this.putObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean added = new AtomicBoolean();
        final AtomicReference<Object> replacedVal = new AtomicReference<Object>(null);
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        final long now = this.timeSource.getTimeMillis();
        try {
            BiFunction mappingFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                @Override
                public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                    if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        mappedValue = null;
                    }
                    if (mappedValue == null) {
                        OffHeapValueHolder newValue = AbstractOffHeapStore.this.newCreateValueHolder(key, value, now, eventSink);
                        added.set(newValue != null);
                        return newValue;
                    }
                    OffHeapValueHolder newValue = AbstractOffHeapStore.this.newUpdatedValueHolder(key, value, mappedValue, now, eventSink);
                    replacedVal.set(mappedValue);
                    return newValue;
                }
            };
            this.computeWithRetry(key, mappingFunction, false);
            this.eventDispatcher.releaseEventSink(eventSink);
            if (replacedVal.get() != null) {
                this.putObserver.end(StoreOperationOutcomes.PutOutcome.REPLACED);
                return Store.PutStatus.UPDATE;
            }
            if (added.get()) {
                this.putObserver.end(StoreOperationOutcomes.PutOutcome.PUT);
                return Store.PutStatus.PUT;
            }
            this.putObserver.end(StoreOperationOutcomes.PutOutcome.REPLACED);
            return Store.PutStatus.NOOP;
        }
        catch (StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw re;
        }
    }

    @Override
    public Store.ValueHolder<V> putIfAbsent(K key, final V value) throws NullPointerException, StoreAccessException {
        this.putIfAbsentObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference returnValue = new AtomicReference();
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        try {
            BiFunction mappingFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                @Override
                public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                    long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        if (mappedValue != null) {
                            AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        }
                        return AbstractOffHeapStore.this.newCreateValueHolder(mappedKey, value, now, eventSink);
                    }
                    mappedValue.forceDeserialization();
                    returnValue.set(mappedValue);
                    return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now, eventSink);
                }
            };
            this.computeWithRetry(key, mappingFunction, false);
            this.eventDispatcher.releaseEventSink(eventSink);
            Store.ValueHolder resultHolder = (Store.ValueHolder)returnValue.get();
            if (resultHolder == null) {
                this.putIfAbsentObserver.end(StoreOperationOutcomes.PutIfAbsentOutcome.PUT);
                return null;
            }
            this.putIfAbsentObserver.end(StoreOperationOutcomes.PutIfAbsentOutcome.HIT);
            return resultHolder;
        }
        catch (StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw re;
        }
    }

    @Override
    public boolean remove(K key) throws StoreAccessException {
        this.removeObserver.begin();
        this.checkKey(key);
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        final long now = this.timeSource.getTimeMillis();
        final AtomicBoolean removed = new AtomicBoolean(false);
        try {
            this.backingMap().computeIfPresent(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                @Override
                public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                    if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    if (mappedValue != null) {
                        removed.set(true);
                        eventSink.removed(mappedKey, mappedValue);
                    }
                    return null;
                }
            });
            this.eventDispatcher.releaseEventSink(eventSink);
            if (removed.get()) {
                this.removeObserver.end(StoreOperationOutcomes.RemoveOutcome.REMOVED);
            } else {
                this.removeObserver.end(StoreOperationOutcomes.RemoveOutcome.MISS);
            }
            return removed.get();
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            StorePassThroughException.handleRuntimeException(re);
            return false;
        }
    }

    @Override
    public Store.RemoveStatus remove(K key, final V value) throws StoreAccessException {
        this.conditionalRemoveObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean removed = new AtomicBoolean(false);
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        final AtomicBoolean mappingExists = new AtomicBoolean();
        try {
            this.backingMap().computeIfPresent(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                @Override
                public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                    long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    if (mappedValue.value().equals(value)) {
                        removed.set(true);
                        eventSink.removed(mappedKey, mappedValue);
                        return null;
                    }
                    mappingExists.set(true);
                    return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now, eventSink);
                }
            });
            this.eventDispatcher.releaseEventSink(eventSink);
            if (removed.get()) {
                this.conditionalRemoveObserver.end(StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED);
                return Store.RemoveStatus.REMOVED;
            }
            this.conditionalRemoveObserver.end(StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
            if (mappingExists.get()) {
                return Store.RemoveStatus.KEY_PRESENT;
            }
            return Store.RemoveStatus.KEY_MISSING;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            StorePassThroughException.handleRuntimeException(re);
            return Store.RemoveStatus.KEY_MISSING;
        }
    }

    @Override
    public Store.ValueHolder<V> replace(K key, final V value) throws NullPointerException, StoreAccessException {
        this.replaceObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        BiFunction mappingFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            @Override
            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                    }
                    return null;
                }
                returnValue.set(mappedValue);
                return AbstractOffHeapStore.this.newUpdatedValueHolder(mappedKey, value, mappedValue, now, eventSink);
            }
        };
        try {
            this.computeWithRetry(key, mappingFunction, false);
            this.eventDispatcher.releaseEventSink(eventSink);
            Store.ValueHolder resultHolder = returnValue.get();
            if (resultHolder != null) {
                this.replaceObserver.end(StoreOperationOutcomes.ReplaceOutcome.REPLACED);
            } else {
                this.replaceObserver.end(StoreOperationOutcomes.ReplaceOutcome.MISS);
            }
            return resultHolder;
        }
        catch (StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw re;
        }
    }

    @Override
    public Store.ReplaceStatus replace(K key, final V oldValue, final V newValue) throws NullPointerException, IllegalArgumentException, StoreAccessException {
        this.conditionalReplaceObserver.begin();
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        final AtomicBoolean replaced = new AtomicBoolean(false);
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        final AtomicBoolean mappingExists = new AtomicBoolean();
        BiFunction mappingFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            @Override
            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                    }
                    return null;
                }
                if (oldValue.equals(mappedValue.value())) {
                    replaced.set(true);
                    return AbstractOffHeapStore.this.newUpdatedValueHolder(mappedKey, newValue, mappedValue, now, eventSink);
                }
                mappingExists.set(true);
                return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now, eventSink);
            }
        };
        try {
            this.computeWithRetry(key, mappingFunction, false);
            this.eventDispatcher.releaseEventSink(eventSink);
            if (replaced.get()) {
                this.conditionalReplaceObserver.end(StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED);
                return Store.ReplaceStatus.HIT;
            }
            this.conditionalReplaceObserver.end(StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
            if (mappingExists.get()) {
                return Store.ReplaceStatus.MISS_PRESENT;
            }
            return Store.ReplaceStatus.MISS_NOT_PRESENT;
        }
        catch (StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw re;
        }
    }

    @Override
    public void clear() throws StoreAccessException {
        try {
            this.backingMap().clear();
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException(re);
        }
    }

    @Override
    public StoreEventSource<K, V> getStoreEventSource() {
        return this.eventDispatcher;
    }

    @Override
    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
            private final Iterator<Map.Entry<K, OffHeapValueHolder<V>>> mapIterator;
            {
                this.mapIterator = AbstractOffHeapStore.this.backingMap().entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mapIterator.hasNext();
            }

            @Override
            public Cache.Entry<K, Store.ValueHolder<V>> next() throws StoreAccessException {
                Map.Entry next = this.mapIterator.next();
                final Object key = next.getKey();
                final OffHeapValueHolder value = next.getValue();
                return new Cache.Entry<K, Store.ValueHolder<V>>(){

                    @Override
                    public K getKey() {
                        return key;
                    }

                    @Override
                    public Store.ValueHolder<V> getValue() {
                        return value;
                    }
                };
            }
        };
    }

    @Override
    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        return this.compute(key, mappingFunction, REPLACE_EQUALS_TRUE);
    }

    @Override
    public Store.ValueHolder<V> compute(final K key, final BiFunction<? super K, ? super V, ? extends V> mappingFunction, final NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        this.computeObserver.begin();
        this.checkKey(key);
        final AtomicBoolean write = new AtomicBoolean(false);
        final AtomicReference valueHeld = new AtomicReference();
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            @Override
            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                Object existingValue = null;
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                    }
                    mappedValue = null;
                } else {
                    existingValue = mappedValue.value();
                }
                Object computedValue = mappingFunction.apply(mappedKey, existingValue);
                if (computedValue == null) {
                    if (mappedValue != null) {
                        write.set(true);
                        eventSink.removed(mappedKey, mappedValue);
                    }
                    return null;
                }
                if (AbstractOffHeapStore.this.safeEquals(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    if (mappedValue != null) {
                        OffHeapValueHolder valueHolder = AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now, eventSink);
                        if (valueHolder == null) {
                            valueHeld.set(mappedValue);
                        }
                        return valueHolder;
                    }
                    return null;
                }
                AbstractOffHeapStore.this.checkValue(computedValue);
                write.set(true);
                if (mappedValue != null) {
                    OffHeapValueHolder valueHolder = AbstractOffHeapStore.this.newUpdatedValueHolder(key, computedValue, mappedValue, now, eventSink);
                    if (valueHolder == null) {
                        valueHeld.set(new BasicOffHeapValueHolder(mappedValue.getId(), computedValue, now, now));
                    }
                    return valueHolder;
                }
                return AbstractOffHeapStore.this.newCreateValueHolder(key, computedValue, now, eventSink);
            }
        };
        try {
            OffHeapValueHolder result = this.computeWithRetry(key, computeFunction, false);
            if (result == null && valueHeld.get() != null) {
                result = (OffHeapValueHolder)valueHeld.get();
            }
            this.eventDispatcher.releaseEventSink(eventSink);
            if (result == null) {
                if (write.get()) {
                    this.computeObserver.end(StoreOperationOutcomes.ComputeOutcome.REMOVED);
                } else {
                    this.computeObserver.end(StoreOperationOutcomes.ComputeOutcome.MISS);
                }
            } else if (write.get()) {
                this.computeObserver.end(StoreOperationOutcomes.ComputeOutcome.PUT);
            } else {
                this.computeObserver.end(StoreOperationOutcomes.ComputeOutcome.HIT);
            }
            return result;
        }
        catch (StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw re;
        }
    }

    @Override
    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, false, false);
    }

    private Store.ValueHolder<V> internalComputeIfAbsent(K key, final Function<? super K, ? extends V> mappingFunction, boolean fault, final boolean delayedDeserialization) throws StoreAccessException {
        if (fault) {
            this.computeIfAbsentAndFaultObserver.begin();
        } else {
            this.computeIfAbsentObserver.begin();
        }
        this.checkKey(key);
        final AtomicBoolean write = new AtomicBoolean(false);
        final AtomicReference valueHeld = new AtomicReference();
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            @Override
            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                    }
                    write.set(true);
                    Object computedValue = mappingFunction.apply(mappedKey);
                    if (computedValue == null) {
                        return null;
                    }
                    AbstractOffHeapStore.this.checkValue(computedValue);
                    return AbstractOffHeapStore.this.newCreateValueHolder(mappedKey, computedValue, now, eventSink);
                }
                OffHeapValueHolder valueHolder = AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now, eventSink);
                if (valueHolder != null) {
                    if (delayedDeserialization) {
                        mappedValue.detach();
                    } else {
                        mappedValue.forceDeserialization();
                    }
                } else {
                    valueHeld.set(mappedValue);
                }
                return valueHolder;
            }
        };
        try {
            OffHeapValueHolder computeResult = this.computeWithRetry(key, computeFunction, fault);
            if (computeResult == null && valueHeld.get() != null) {
                computeResult = (OffHeapValueHolder)valueHeld.get();
            }
            this.eventDispatcher.releaseEventSink(eventSink);
            if (write.get()) {
                if (computeResult != null) {
                    if (fault) {
                        this.computeIfAbsentAndFaultObserver.end(AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.PUT);
                    } else {
                        this.computeIfAbsentObserver.end(StoreOperationOutcomes.ComputeIfAbsentOutcome.PUT);
                    }
                } else if (fault) {
                    this.computeIfAbsentAndFaultObserver.end(AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.NOOP);
                } else {
                    this.computeIfAbsentObserver.end(StoreOperationOutcomes.ComputeIfAbsentOutcome.NOOP);
                }
            } else if (fault) {
                this.computeIfAbsentAndFaultObserver.end(AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.HIT);
            } else {
                this.computeIfAbsentObserver.end(StoreOperationOutcomes.ComputeIfAbsentOutcome.HIT);
            }
            return computeResult;
        }
        catch (StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw re;
        }
    }

    @Override
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    @Override
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            BiFunction biFunction = new BiFunction<K, V, V>(){

                @Override
                public V apply(final K k, final V v) {
                    Map.Entry entry = new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return k;
                        }

                        @Override
                        public V getValue() {
                            return v;
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    Iterator iterator = ((Iterable)remappingFunction.apply(Collections.singleton(entry))).iterator();
                    Map.Entry result = (Map.Entry)iterator.next();
                    if (result != null) {
                        AbstractOffHeapStore.this.checkKey(result.getKey());
                        return result.getValue();
                    }
                    return null;
                }
            };
            Store.ValueHolder<V> computed = this.compute(key, biFunction, replaceEqual);
            result.put(key, computed);
        }
        return result;
    }

    @Override
    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            Function function = new Function<K, V>(){

                @Override
                public V apply(K k) {
                    Iterator iterator = ((Iterable)mappingFunction.apply(Collections.singleton(k))).iterator();
                    Map.Entry result = (Map.Entry)iterator.next();
                    if (result != null) {
                        AbstractOffHeapStore.this.checkKey(result.getKey());
                        return result.getValue();
                    }
                    return null;
                }
            };
            Store.ValueHolder<V> computed = this.computeIfAbsent(key, function);
            result.put(key, computed);
        }
        return result;
    }

    @Override
    public Store.ValueHolder<V> getAndFault(K key) throws StoreAccessException {
        this.getAndFaultObserver.begin();
        this.checkKey(key);
        Store.ValueHolder mappedValue = null;
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        try {
            mappedValue = this.backingMap().computeIfPresentAndPin(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                @Override
                public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                    if (mappedValue.isExpired(AbstractOffHeapStore.this.timeSource.getTimeMillis(), TimeUnit.MILLISECONDS)) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    mappedValue.detach();
                    return mappedValue;
                }
            });
            this.eventDispatcher.releaseEventSink(eventSink);
            if (mappedValue == null) {
                this.getAndFaultObserver.end(AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.MISS);
            } else {
                this.getAndFaultObserver.end(AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.HIT);
            }
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            StorePassThroughException.handleRuntimeException(re);
        }
        return mappedValue;
    }

    @Override
    public Store.ValueHolder<V> computeIfAbsentAndFault(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, true, true);
    }

    @Override
    public boolean flush(K key, final Store.ValueHolder<V> valueFlushed) {
        this.flushObserver.begin();
        this.checkKey(key);
        final StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
        try {
            boolean result = this.backingMap().computeIfPinned(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                @Override
                public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> valuePresent) {
                    if (valuePresent.getId() == valueFlushed.getId()) {
                        if (valueFlushed.isExpired(AbstractOffHeapStore.this.timeSource.getTimeMillis(), TimeUnit.MILLISECONDS)) {
                            AbstractOffHeapStore.this.onExpiration(k, valuePresent, eventSink);
                            return null;
                        }
                        valuePresent.updateMetadata(valueFlushed);
                        valuePresent.writeBack();
                    }
                    return valuePresent;
                }
            }, new Function<OffHeapValueHolder<V>, Boolean>(){

                @Override
                public Boolean apply(OffHeapValueHolder<V> valuePresent) {
                    return valuePresent.getId() == valueFlushed.getId();
                }
            });
            this.eventDispatcher.releaseEventSink(eventSink);
            if (result) {
                this.flushObserver.end(AuthoritativeTierOperationOutcomes.FlushOutcome.HIT);
                return true;
            }
            this.flushObserver.end(AuthoritativeTierOperationOutcomes.FlushOutcome.MISS);
            return false;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw re;
        }
    }

    @Override
    public void setInvalidationValve(AuthoritativeTier.InvalidationValve valve) {
        this.valve = valve;
    }

    @Override
    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListener = invalidationListener;
        this.mapEvictionListener.setInvalidationListener(invalidationListener);
    }

    @Override
    public void invalidate(final K key) throws StoreAccessException {
        this.invalidateObserver.begin();
        final AtomicBoolean removed = new AtomicBoolean(false);
        try {
            this.backingMap().computeIfPresent(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                @Override
                public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> present) {
                    removed.set(true);
                    AbstractOffHeapStore.this.notifyInvalidation(key, present);
                    return null;
                }
            });
            if (removed.get()) {
                this.invalidateObserver.end(LowerCachingTierOperationsOutcome.InvalidateOutcome.REMOVED);
            } else {
                this.invalidateObserver.end(LowerCachingTierOperationsOutcome.InvalidateOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException(re);
        }
    }

    @Override
    public void invalidateAll() throws StoreAccessException {
        this.invalidateAllObserver.begin();
        StoreAccessException exception = null;
        long errorCount = 0L;
        for (Object k : this.backingMap().keySet()) {
            try {
                this.invalidate(k);
            }
            catch (StoreAccessException e) {
                ++errorCount;
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            this.invalidateAllObserver.end(LowerCachingTierOperationsOutcome.InvalidateAllOutcome.FAILURE);
            throw new StoreAccessException("invalidateAll failed - error count: " + errorCount, exception);
        }
        this.invalidateAllObserver.end(LowerCachingTierOperationsOutcome.InvalidateAllOutcome.SUCCESS);
    }

    @Override
    public void invalidateAllWithHash(long hash) {
        this.invalidateAllWithHashObserver.begin();
        Map<K, OffHeapValueHolder<V>> removed = this.backingMap().removeAllWithHash((int)hash);
        for (Map.Entry<K, OffHeapValueHolder<V>> entry : removed.entrySet()) {
            this.notifyInvalidation(entry.getKey(), entry.getValue());
        }
        this.invalidateAllWithHashObserver.end(LowerCachingTierOperationsOutcome.InvalidateAllWithHashOutcome.SUCCESS);
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    @Override
    public Store.ValueHolder<V> getAndRemove(final K key) throws StoreAccessException {
        this.getAndRemoveObserver.begin();
        this.checkKey(key);
        final AtomicReference valueHolderAtomicReference = new AtomicReference();
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            @Override
            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpirationInCachingTier(mappedValue, key);
                    }
                    return null;
                }
                mappedValue.detach();
                valueHolderAtomicReference.set(mappedValue);
                return null;
            }
        };
        try {
            this.backingMap().compute(key, computeFunction, false);
            Store.ValueHolder result = (Store.ValueHolder)valueHolderAtomicReference.get();
            if (result == null) {
                this.getAndRemoveObserver.end(LowerCachingTierOperationsOutcome.GetAndRemoveOutcome.MISS);
            } else {
                this.getAndRemoveObserver.end(LowerCachingTierOperationsOutcome.GetAndRemoveOutcome.HIT_REMOVED);
            }
            return result;
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException(re);
            return null;
        }
    }

    @Override
    public Store.ValueHolder<V> installMapping(final K key, final Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        this.installMappingObserver.begin();
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            @Override
            public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> offHeapValueHolder) {
                if (offHeapValueHolder != null) {
                    throw new AssertionError();
                }
                Store.ValueHolder valueHolder = (Store.ValueHolder)source.apply(k);
                if (valueHolder != null) {
                    if (valueHolder.isExpired(AbstractOffHeapStore.this.timeSource.getTimeMillis(), TimeUnit.MILLISECONDS)) {
                        AbstractOffHeapStore.this.onExpirationInCachingTier(valueHolder, key);
                        return null;
                    }
                    return AbstractOffHeapStore.this.newTransferValueHolder(valueHolder);
                }
                return null;
            }
        };
        try {
            OffHeapValueHolder<V> computeResult = this.computeWithRetry(key, computeFunction, false);
            if (computeResult != null) {
                this.installMappingObserver.end(LowerCachingTierOperationsOutcome.InstallMappingOutcome.PUT);
            } else {
                this.installMappingObserver.end(LowerCachingTierOperationsOutcome.InstallMappingOutcome.NOOP);
            }
            return computeResult;
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException(re);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OffHeapValueHolder<V> computeWithRetry(K key, BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>> computeFunction, boolean fault) throws StoreAccessException {
        OffHeapValueHolder<V> computeResult = null;
        try {
            computeResult = this.backingMap().compute(key, computeFunction, fault);
        }
        catch (OversizeMappingException ex) {
            try {
                this.evictionAdvisor().setSwitchedOn(false);
                this.invokeValve();
                computeResult = this.backingMap().compute(key, computeFunction, fault);
            }
            catch (OversizeMappingException e) {
                throw new StoreAccessException("The element with key '" + key + "' is too large to be stored" + " in this offheap store.", e);
            }
            catch (RuntimeException e) {
                StorePassThroughException.handleRuntimeException(e);
            }
            finally {
                this.evictionAdvisor().setSwitchedOn(true);
            }
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException(re);
        }
        return computeResult;
    }

    private boolean safeEquals(V existingValue, V computedValue) {
        return existingValue == computedValue || existingValue != null && existingValue.equals(computedValue);
    }

    private OffHeapValueHolder<V> setAccessTimeAndExpiryThenReturnMapping(K key, OffHeapValueHolder<V> valueHolder, long now, StoreEventSink<K, V> eventSink) {
        Duration duration = Duration.ZERO;
        try {
            duration = this.expiry.getExpiryForAccess(key, valueHolder);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
        }
        if (Duration.ZERO.equals(duration)) {
            this.onExpiration(key, valueHolder, eventSink);
            return null;
        }
        valueHolder.accessed(now, duration);
        valueHolder.writeBack();
        return valueHolder;
    }

    private OffHeapValueHolder<V> newUpdatedValueHolder(K key, V value, OffHeapValueHolder<V> existing, long now, StoreEventSink<K, V> eventSink) {
        eventSink.updated(key, existing, value);
        Duration duration = Duration.ZERO;
        try {
            duration = this.expiry.getExpiryForUpdate(key, existing, value);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
        }
        if (Duration.ZERO.equals(duration)) {
            eventSink.expired(key, ValueSuppliers.supplierOf(value));
            return null;
        }
        if (duration == null) {
            return new BasicOffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, existing.expirationTime(OffHeapValueHolder.TIME_UNIT));
        }
        if (duration.isInfinite()) {
            return new BasicOffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, -1L);
        }
        return new BasicOffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, AbstractOffHeapStore.safeExpireTime(now, duration));
    }

    private OffHeapValueHolder<V> newCreateValueHolder(K key, V value, long now, StoreEventSink<K, V> eventSink) {
        Duration duration = Duration.ZERO;
        try {
            duration = this.expiry.getExpiryForCreation(key, value);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
        }
        if (Duration.ZERO.equals(duration)) {
            return null;
        }
        eventSink.created(key, value);
        if (duration.isInfinite()) {
            return new BasicOffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, -1L);
        }
        return new BasicOffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, AbstractOffHeapStore.safeExpireTime(now, duration));
    }

    private OffHeapValueHolder<V> newTransferValueHolder(Store.ValueHolder<V> valueHolder) {
        if (valueHolder instanceof BinaryValueHolder && ((BinaryValueHolder)((Object)valueHolder)).isBinaryValueAvailable()) {
            return new BinaryOffHeapValueHolder(valueHolder.getId(), valueHolder.value(), ((BinaryValueHolder)((Object)valueHolder)).getBinaryValue(), valueHolder.creationTime(OffHeapValueHolder.TIME_UNIT), valueHolder.expirationTime(OffHeapValueHolder.TIME_UNIT), valueHolder.lastAccessTime(OffHeapValueHolder.TIME_UNIT), valueHolder.hits());
        }
        return new BasicOffHeapValueHolder(valueHolder.getId(), valueHolder.value(), valueHolder.creationTime(OffHeapValueHolder.TIME_UNIT), valueHolder.expirationTime(OffHeapValueHolder.TIME_UNIT), valueHolder.lastAccessTime(OffHeapValueHolder.TIME_UNIT), valueHolder.hits());
    }

    private void invokeValve() throws StoreAccessException {
        AuthoritativeTier.InvalidationValve valve = this.valve;
        if (valve != null) {
            valve.invalidateAll();
        }
    }

    private static long safeExpireTime(long now, Duration duration) {
        long millis = OffHeapValueHolder.TIME_UNIT.convert(duration.getLength(), duration.getTimeUnit());
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long result = now + millis;
        if (result < 0L) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    private void checkKey(K keyObject) {
        if (keyObject == null) {
            throw new NullPointerException();
        }
        if (!this.keyType.isAssignableFrom(keyObject.getClass())) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    private void checkValue(V valueObject) {
        if (valueObject == null) {
            throw new NullPointerException();
        }
        if (!this.valueType.isAssignableFrom(valueObject.getClass())) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    private void onExpirationInCachingTier(Store.ValueHolder<V> mappedValue, K key) {
        this.expirationObserver.begin();
        this.invalidationListener.onInvalidation(key, mappedValue);
        this.expirationObserver.end(StoreOperationOutcomes.ExpirationOutcome.SUCCESS);
    }

    private void onExpiration(K mappedKey, Store.ValueHolder<V> mappedValue, StoreEventSink<K, V> eventSink) {
        this.expirationObserver.begin();
        eventSink.expired(mappedKey, mappedValue);
        this.invalidationListener.onInvalidation(mappedKey, mappedValue);
        this.expirationObserver.end(StoreOperationOutcomes.ExpirationOutcome.SUCCESS);
    }

    protected abstract EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap();

    protected abstract SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor();

    protected static <K, V> SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> wrap(EvictionAdvisor<? super K, ? super V> delegate) {
        return new OffHeapEvictionAdvisorWrapper(delegate);
    }

    static class BackingMapEvictionListener<K, V>
    implements EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, OffHeapValueHolder<V>> {
        private final StoreEventDispatcher<K, V> eventDispatcher;
        private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
        private volatile CachingTier.InvalidationListener<K, V> invalidationListener;

        private BackingMapEvictionListener(StoreEventDispatcher<K, V> eventDispatcher, OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver) {
            CachingTier.InvalidationListener nullInvalidationListener;
            this.eventDispatcher = eventDispatcher;
            this.evictionObserver = evictionObserver;
            this.invalidationListener = nullInvalidationListener = NULL_INVALIDATION_LISTENER;
        }

        public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
            if (invalidationListener == null) {
                throw new NullPointerException("invalidation listener cannot be null");
            }
            this.invalidationListener = invalidationListener;
        }

        @Override
        public void onEviction(K key, OffHeapValueHolder<V> value) {
            this.evictionObserver.begin();
            StoreEventSink<K, V> eventSink = this.eventDispatcher.eventSink();
            try {
                eventSink.evicted(key, value);
                this.eventDispatcher.releaseEventSink(eventSink);
            }
            catch (RuntimeException re) {
                this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            }
            this.invalidationListener.onInvalidation(key, value);
            this.evictionObserver.end(StoreOperationOutcomes.EvictionOutcome.SUCCESS);
        }
    }

    private static class OffHeapEvictionAdvisorWrapper<K, V>
    implements SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> {
        private final EvictionAdvisor<? super K, ? super V> delegate;
        private volatile boolean adviceEnabled;

        private OffHeapEvictionAdvisorWrapper(EvictionAdvisor<? super K, ? super V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean adviseAgainstEviction(K key, OffHeapValueHolder<V> value) {
            try {
                return this.delegate.adviseAgainstEviction(key, value.value());
            }
            catch (Exception e) {
                LOG.error("Exception raised while running eviction advisor - Eviction will assume entry is NOT advised against eviction", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isSwitchedOn() {
            return this.adviceEnabled;
        }

        @Override
        public void setSwitchedOn(boolean switchedOn) {
            this.adviceEnabled = switchedOn;
        }
    }
}

