/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import java.util.List;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class UrlConstraint
extends AbstractConstraint {
    private final UrlValidator validator;

    public UrlConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.validator = (UrlValidator)this.constraintParameter;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && String.class.isAssignableFrom(type);
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        RegexValidator domainValidator;
        if (constraintParameter instanceof Boolean || constraintParameter instanceof UrlValidator) {
            domainValidator = null;
        } else if (constraintParameter instanceof String) {
            domainValidator = new RegexValidator((String)constraintParameter);
        } else if (constraintParameter instanceof List) {
            List regexpList = (List)constraintParameter;
            domainValidator = new RegexValidator(regexpList.toArray(new String[regexpList.size()]));
        } else {
            throw new IllegalArgumentException("Parameter for constraint [url] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean, string, or list value");
        }
        UrlValidator validator = new UrlValidator(domainValidator, 3L);
        return validator;
    }

    @Override
    public String getName() {
        return "url";
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (!this.validator.isValid(propertyValue.toString())) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue};
            this.rejectValue(target, errors, "default.invalid.url.message", "url.invalid", args);
        }
    }
}

