/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.compare.core;

import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.util.StringUtils;

public abstract class CommonCatalogSchemaComparator
implements DatabaseObjectComparator {
    protected boolean equalsSchemas(Database accordingTo, String schemaName1, String schemaName2) {
        if (CatalogAndSchema.CatalogAndSchemaCase.ORIGINAL_CASE.equals((Object)accordingTo.getSchemaAndCatalogCase())) {
            return StringUtils.trimToEmpty(schemaName1).equals(StringUtils.trimToEmpty(schemaName2));
        }
        return StringUtils.trimToEmpty(schemaName1).equalsIgnoreCase(StringUtils.trimToEmpty(schemaName2));
    }

    protected String getComparisonSchemaOrCatalog(Database accordingTo, CompareControl.SchemaComparison comparison) {
        if (accordingTo.supportsSchemas()) {
            return comparison.getComparisonSchema().getSchemaName();
        }
        if (accordingTo.supportsCatalogs()) {
            return comparison.getComparisonSchema().getCatalogName();
        }
        return null;
    }

    protected String getReferenceSchemaOrCatalog(Database accordingTo, CompareControl.SchemaComparison comparison) {
        if (accordingTo.supportsSchemas()) {
            return comparison.getReferenceSchema().getSchemaName();
        }
        if (accordingTo.supportsCatalogs()) {
            return comparison.getReferenceSchema().getCatalogName();
        }
        return null;
    }
}

