/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.support;

import java.lang.reflect.Method;
import org.grails.datastore.mapping.core.grailsversion.GrailsVersion;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class HibernateVersionSupport {
    private static Method getFlushMode;
    private static Method setFlushMode;
    private static Method createQuery;

    public static FlushMode getFlushMode(Session session) {
        if (session != null) {
            return (FlushMode)ReflectionUtils.invokeMethod((Method)getFlushMode, (Object)session);
        }
        return FlushMode.MANUAL;
    }

    public static void setFlushMode(Session session, FlushMode flushMode) {
        ReflectionUtils.invokeMethod((Method)setFlushMode, (Object)session, (Object[])new Object[]{flushMode});
    }

    public static boolean isAtLeastVersion(String required) {
        String hibernateVersion = Hibernate.class.getPackage().getImplementationVersion();
        if (hibernateVersion != null) {
            return GrailsVersion.isAtLeast((String)hibernateVersion, (String)required);
        }
        return false;
    }

    public static Query createQuery(Session session, String query) {
        return (Query)ReflectionUtils.invokeMethod((Method)createQuery, (Object)session, (Object[])new Object[]{query});
    }

    static {
        try {
            getFlushMode = Session.class.getMethod("getHibernateFlushMode", new Class[0]);
            setFlushMode = Session.class.getMethod("setHibernateFlushMode", FlushMode.class);
            getFlushMode.setAccessible(true);
            setFlushMode.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            try {
                getFlushMode = Session.class.getMethod("getFlushMode", new Class[0]);
                setFlushMode = Session.class.getMethod("setFlushMode", FlushMode.class);
                getFlushMode.setAccessible(true);
                setFlushMode.setAccessible(true);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalStateException("No compatible Hibernate getFlushMode signature found", ex2);
            }
        }
        try {
            ClassLoader classLoader = HibernateVersionSupport.class.getClassLoader();
            Class queryProducerClass = ClassUtils.forName((String)"org.hibernate.query.QueryProducer", (ClassLoader)classLoader);
            createQuery = queryProducerClass.getMethod("createQuery", String.class);
            createQuery.setAccessible(true);
        }
        catch (Throwable e) {
            try {
                createQuery = SharedSessionContract.class.getMethod("createQuery", String.class);
                createQuery.setAccessible(true);
            }
            catch (Throwable e1) {
                throw new IllegalStateException("Incompatible version of Hibernate on classpath", e1);
            }
        }
        Assert.state((FlushMode.class == getFlushMode.getReturnType() ? 1 : 0) != 0, (String)"Incompatible version of Hibernate on classpath");
    }
}

