/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Timestamp;
import org.jadira.usertype.dateandtime.joda.util.ZoneHelper;
import org.jadira.usertype.dateandtime.shared.spi.AbstractVersionableTimestampColumnMapper;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class TimestampColumnDateTimeMapper
extends AbstractVersionableTimestampColumnMapper<DateTime> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss'.'").appendFractionOfSecond(0, 9).toFormatter();
    private DateTimeZone databaseZone = DateTimeZone.UTC;
    private DateTimeZone javaZone = null;

    public DateTime fromNonNullString(String s) {
        return new DateTime((Object)s);
    }

    public DateTime fromNonNullValue(Timestamp value) {
        DateTimeZone currentDatabaseZone = this.databaseZone == null ? ZoneHelper.getDefault() : this.databaseZone;
        DateTimeZone currentJavaZone = this.javaZone == null ? ZoneHelper.getDefault() : this.javaZone;
        DateTime dateTime = DATETIME_FORMATTER.withZone(currentDatabaseZone).parseDateTime(value.toString());
        return dateTime.withZone(currentJavaZone);
    }

    public String toNonNullString(DateTime value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(DateTime value) {
        DateTimeZone currentDatabaseZone = this.databaseZone == null ? ZoneHelper.getDefault() : this.databaseZone;
        String formattedTimestamp = DATETIME_FORMATTER.print((ReadableInstant)(value = value.withZone(currentDatabaseZone)));
        if (formattedTimestamp.endsWith(".")) {
            formattedTimestamp = formattedTimestamp.substring(0, formattedTimestamp.length() - 1);
        }
        Timestamp timestamp = Timestamp.valueOf(formattedTimestamp);
        return timestamp;
    }

    public void setDatabaseZone(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public void setJavaZone(DateTimeZone javaZone) {
        this.javaZone = javaZone;
    }
}

