/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline;

import asset.pipeline.AssetPipelineConfigHolder;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class AssetPipelineResponseBuilder
implements GroovyObject {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public String uri;
    public String ifNoneMatchHeader;
    public String ifModifiedSinceHeader;
    public Integer statusCode;
    private Date lastModifiedDate;
    public Map<String, String> headers;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AssetPipelineResponseBuilder(String uri, String ifNoneMatchHeader, String ifModifiedSinceHeader, Date lastModifiedDate) {
        Date date;
        String string;
        String string2;
        String string3;
        MetaClass metaClass;
        Map map;
        int n = 200;
        this.statusCode = n;
        this.headers = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.uri = string3 = uri;
        this.ifNoneMatchHeader = string2 = ifNoneMatchHeader;
        this.ifModifiedSinceHeader = string = ifModifiedSinceHeader;
        this.lastModifiedDate = date = lastModifiedDate;
        boolean digestVersion = this.isDigestVersion();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.checkDateChanged())) {
            int n2 = 304;
            this.statusCode = n2;
        } else {
            Boolean bl = this.checkETag();
            if (bl == null ? false : bl) {
                String string4 = "Accept-Encoding";
                DefaultGroovyMethods.putAt(this.headers, (Object)"Vary", (Object)string4);
                if (digestVersion && !uri.endsWith(".html")) {
                    String string5 = "public, max-age=31536000";
                    DefaultGroovyMethods.putAt(this.headers, (Object)"Cache-Control", (Object)string5);
                } else {
                    String string6 = "no-cache";
                    DefaultGroovyMethods.putAt(this.headers, (Object)"Cache-Control", (Object)string6);
                }
            }
        }
    }

    public AssetPipelineResponseBuilder(String uri, String ifNoneMatchHeader, String ifModifiedSinceHeader) {
        this(uri, ifNoneMatchHeader, ifModifiedSinceHeader, null);
    }

    public AssetPipelineResponseBuilder(String uri, String ifNoneMatchHeader) {
        this(uri, ifNoneMatchHeader, null, null);
    }

    public AssetPipelineResponseBuilder(String uri) {
        this(uri, null, null, null);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getCurrentETag() {
        String manifestPath = this.uri;
        if (this.uri.startsWith("/")) {
            String string;
            manifestPath = string = this.uri.substring(1);
        }
        Properties manifest = AssetPipelineConfigHolder.getManifest();
        Properties properties = manifest;
        String string = properties != null ? properties.getProperty(manifestPath) : null;
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"\"", (CharSequence)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : manifestPath)), (CharSequence)"\"");
    }

    public boolean isDigestVersion() {
        String manifestPath = this.uri;
        if (this.uri.startsWith("/")) {
            String string;
            manifestPath = string = this.uri.substring(1);
        }
        Properties manifest = AssetPipelineConfigHolder.getManifest();
        Properties properties = manifest;
        return !DefaultTypeTransformation.booleanUnbox(properties != null ? properties.getProperty(manifestPath, null) : null);
    }

    public Boolean checkETag() {
        String etagName = this.getCurrentETag();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.ifNoneMatchHeader) && ScriptBytecodeAdapter.compareEqual((Object)this.ifNoneMatchHeader, (Object)etagName)) {
            int n = 304;
            this.statusCode = n;
            return false;
        }
        String string = etagName;
        DefaultGroovyMethods.putAt(this.headers, (Object)"ETag", (Object)string);
        return true;
    }

    public Boolean checkDateChanged() {
        SimpleDateFormat sdf = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        boolean hasNotChanged = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)this.lastModifiedDate)) {
            String string = this.getLastModifiedDate(this.lastModifiedDate);
            DefaultGroovyMethods.putAt(this.headers, (Object)"Last-Modified", (Object)string);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.ifModifiedSinceHeader) && DefaultTypeTransformation.booleanUnbox((Object)this.lastModifiedDate)) {
            try {
                boolean bl;
                hasNotChanged = bl = ScriptBytecodeAdapter.compareLessThanEqual((Object)this.lastModifiedDate, (Object)sdf.parse(this.ifModifiedSinceHeader));
            }
            catch (Exception e) {
            }
        }
        return !hasNotChanged;
    }

    private String getLastModifiedDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String lastModifiedDateTimeString = sdf.format(new Date());
        try {
            String string;
            lastModifiedDateTimeString = string = sdf.format(date);
        }
        catch (Exception e) {
        }
        return lastModifiedDateTimeString;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AssetPipelineResponseBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

