/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.opentsdb;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.metrics.opentsdb.OpenTsdbName;
import org.springframework.boot.actuate.metrics.opentsdb.OpenTsdbNamingStrategy;
import org.springframework.util.ObjectUtils;

public class DefaultOpenTsdbNamingStrategy
implements OpenTsdbNamingStrategy {
    public static final String DOMAIN_KEY = "domain";
    public static final String PROCESS_KEY = "process";
    private Map<String, String> tags = new LinkedHashMap<String, String>();
    private Map<String, OpenTsdbName> cache = new HashMap<String, OpenTsdbName>();

    public DefaultOpenTsdbNamingStrategy() {
        this.tags.put(DOMAIN_KEY, "org.springframework.metrics");
        this.tags.put(PROCESS_KEY, ObjectUtils.getIdentityHexString((Object)this));
    }

    public void setTags(Map<String, String> staticTags) {
        this.tags.putAll(staticTags);
    }

    @Override
    public OpenTsdbName getName(String name) {
        if (this.cache.containsKey(name)) {
            return this.cache.get(name);
        }
        OpenTsdbName value = new OpenTsdbName(name);
        value.setTags(this.tags);
        this.cache.put(name, value);
        return value;
    }
}

