/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.styles.table.row;

import fr.opensagres.poi.xwpf.converter.core.TableHeight;
import fr.opensagres.poi.xwpf.converter.core.styles.table.row.AbstractTableRowValueProvider;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STTwipsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHeightRule;

public class TableRowHeightValueProvider
extends AbstractTableRowValueProvider<TableHeight> {
    public static final TableRowHeightValueProvider INSTANCE = new TableRowHeightValueProvider();

    @Override
    public TableHeight getValue(CTTrPr trPr) {
        if (trPr == null) {
            return null;
        }
        if (trPr.sizeOfTrHeightArray() == 0) {
            return null;
        }
        CTHeight trHeight = trPr.getTrHeightArray(0);
        STHeightRule.Enum hRule = trHeight.getHRule();
        boolean minimum = true;
        if (hRule != null) {
            switch (hRule.intValue()) {
                case 3: {
                    minimum = true;
                    break;
                }
                case 2: {
                    minimum = false;
                    break;
                }
                case 1: {
                    return null;
                }
            }
        }
        STTwipsMeasure value = trHeight.xgetVal();
        float height = DxaUtil.dxa2points(value);
        return new TableHeight(height, minimum);
    }
}

