/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.pages;

import grails.core.GrailsTagLibClass;
import grails.gsp.TagLib;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.grails.core.gsp.DefaultGrailsTagLibClass;
import org.grails.taglib.TagLibraryLookup;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class StandaloneTagLibraryLookup
extends TagLibraryLookup
implements ApplicationListener<ContextRefreshedEvent> {
    Set<Object> tagLibInstancesSet;

    private StandaloneTagLibraryLookup() {
    }

    public void afterPropertiesSet() {
        this.registerTagLibraries();
        this.registerTemplateNamespace();
    }

    protected void registerTagLibraries() {
        if (this.tagLibInstancesSet != null) {
            for (Object tagLibInstance : this.tagLibInstancesSet) {
                this.registerTagLib((GrailsTagLibClass)new DefaultGrailsTagLibClass(tagLibInstance.getClass()));
            }
        }
    }

    protected void putTagLib(Map<String, Object> tags, String name, GrailsTagLibClass taglib) {
        for (Object tagLibInstance : this.tagLibInstancesSet) {
            if (tagLibInstance.getClass() != taglib.getClazz()) continue;
            tags.put(name, tagLibInstance);
            break;
        }
    }

    public void setTagLibInstances(List<Object> tagLibInstances) {
        this.tagLibInstancesSet = new LinkedHashSet<Object>();
        this.tagLibInstancesSet.addAll(tagLibInstances);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.detectAndRegisterTabLibBeans();
    }

    public void detectAndRegisterTabLibBeans() {
        if (this.tagLibInstancesSet == null) {
            this.tagLibInstancesSet = new LinkedHashSet<Object>();
        }
        Collection detectedInstances = this.applicationContext.getBeansWithAnnotation(TagLib.class).values();
        for (Object instance : detectedInstances) {
            if (this.tagLibInstancesSet.contains(instance)) continue;
            this.tagLibInstancesSet.add(instance);
            this.registerTagLib((GrailsTagLibClass)new DefaultGrailsTagLibClass(instance.getClass()));
        }
    }
}

