/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.ServiceLocator;

public class ChangeLogHistoryServiceFactory {
    private static ChangeLogHistoryServiceFactory instance;
    private List<ChangeLogHistoryService> registry = new ArrayList<ChangeLogHistoryService>();
    private Map<Database, ChangeLogHistoryService> services = new ConcurrentHashMap<Database, ChangeLogHistoryService>();

    public static synchronized ChangeLogHistoryServiceFactory getInstance() {
        if (instance == null) {
            instance = new ChangeLogHistoryServiceFactory();
        }
        return instance;
    }

    public static synchronized void setInstance(ChangeLogHistoryServiceFactory changeLogHistoryServiceFactory) {
        instance = changeLogHistoryServiceFactory;
    }

    public static synchronized void reset() {
        instance = null;
    }

    private ChangeLogHistoryServiceFactory() {
        try {
            Class<ChangeLogHistoryService>[] classes;
            for (Class<ChangeLogHistoryService> clazz : classes = ServiceLocator.getInstance().findClasses(ChangeLogHistoryService.class)) {
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }

    public void register(ChangeLogHistoryService changeLogHistoryService) {
        this.registry.add(0, changeLogHistoryService);
    }

    public ChangeLogHistoryService getChangeLogService(Database database) {
        if (this.services.containsKey(database)) {
            return this.services.get(database);
        }
        TreeSet<ChangeLogHistoryService> foundServices = new TreeSet<ChangeLogHistoryService>(new Comparator<ChangeLogHistoryService>(){

            @Override
            public int compare(ChangeLogHistoryService o1, ChangeLogHistoryService o2) {
                return -1 * Integer.valueOf(o1.getPriority()).compareTo(o2.getPriority());
            }
        });
        for (ChangeLogHistoryService service : this.registry) {
            if (!service.supports(database)) continue;
            foundServices.add(service);
        }
        if (foundServices.isEmpty()) {
            throw new UnexpectedLiquibaseException("Cannot find ChangeLogHistoryService for " + database.getShortName());
        }
        try {
            ChangeLogHistoryService service;
            ChangeLogHistoryService exampleService = (ChangeLogHistoryService)foundServices.iterator().next();
            Class<?> aClass = exampleService.getClass();
            try {
                aClass.getConstructor(new Class[0]);
                service = (ChangeLogHistoryService)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                service.setDatabase(database);
            }
            catch (NoSuchMethodException e2) {
                service = exampleService;
            }
            this.services.put(database, service);
            return service;
        }
        catch (Exception e3) {
            throw new UnexpectedLiquibaseException(e3);
        }
    }

    public synchronized void resetAll() {
        for (ChangeLogHistoryService changeLogHistoryService : this.registry) {
            changeLogHistoryService.reset();
        }
        instance = null;
    }
}

