/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.multitenancy;

import grails.gorm.multitenancy.Tenants;
import java.io.Serializable;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.PersistenceEventListener;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.engine.event.ValidationEvent;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.TenantId;
import org.grails.datastore.mapping.multitenancy.MultiTenantCapableDatastore;
import org.grails.datastore.mapping.multitenancy.exceptions.TenantException;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.event.PreQueryEvent;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.springframework.context.ApplicationEvent;

public class MultiTenantEventListener
implements PersistenceEventListener {
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return org.grails.datastore.gorm.multitenancy.MultiTenantEventListener.SUPPORTED_EVENTS.contains(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return AbstractHibernateDatastore.class.isAssignableFrom(sourceType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.supportsEventType(event.getClass())) {
            AbstractPersistenceEvent preInsertEvent;
            PersistentEntity entity;
            Datastore hibernateDatastore = (Datastore)event.getSource();
            if (event instanceof PreQueryEvent) {
                PreQueryEvent preQueryEvent = (PreQueryEvent)event;
                Query query = preQueryEvent.getQuery();
                PersistentEntity entity2 = query.getEntity();
                if (entity2.isMultiTenant()) {
                    if (hibernateDatastore == null) {
                        hibernateDatastore = GormEnhancer.findDatastore((Class)entity2.getJavaClass());
                    }
                    if (this.supportsSourceType(hibernateDatastore.getClass())) {
                        ((AbstractHibernateDatastore)hibernateDatastore).enableMultiTenancyFilter();
                    }
                }
            } else if ((event instanceof ValidationEvent || event instanceof PreInsertEvent || event instanceof PreUpdateEvent) && (entity = (preInsertEvent = (AbstractPersistenceEvent)event).getEntity()).isMultiTenant()) {
                Serializable currentId;
                TenantId tenantId = entity.getTenantId();
                if (hibernateDatastore == null) {
                    hibernateDatastore = GormEnhancer.findDatastore((Class)entity.getJavaClass());
                }
                if (this.supportsSourceType(hibernateDatastore.getClass()) && (currentId = hibernateDatastore instanceof MultiTenantCapableDatastore ? Tenants.currentId((MultiTenantCapableDatastore)((MultiTenantCapableDatastore)hibernateDatastore)) : Tenants.currentId(hibernateDatastore.getClass())) != null) {
                    try {
                        if (currentId == "DEFAULT") {
                            currentId = (Serializable)preInsertEvent.getEntityAccess().getProperty(tenantId.getName());
                        }
                        preInsertEvent.getEntityAccess().setProperty(tenantId.getName(), (Object)currentId);
                    }
                    catch (Exception e) {
                        throw new TenantException("Could not assigned tenant id [" + currentId + "] to property [" + tenantId + "], probably due to a type mismatch. You should return a type from the tenant resolver that matches the property type of the tenant id!: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public int getOrder() {
        return 0x3FFFFFFF;
    }
}

