/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.grails.datastore.mapping.core.AbstractAttributeStoringSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.query.api.QueryAliasAwareSession;
import org.grails.datastore.mapping.transactions.Transaction;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.grails.orm.hibernate.IHibernateTemplate;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractHibernateSession
extends AbstractAttributeStoringSession
implements QueryAliasAwareSession {
    protected AbstractHibernateDatastore datastore;
    protected boolean connected = true;
    protected IHibernateTemplate hibernateTemplate;

    protected AbstractHibernateSession(AbstractHibernateDatastore hibernateDatastore, SessionFactory sessionFactory) {
        this.datastore = hibernateDatastore;
    }

    public boolean isSchemaless() {
        return false;
    }

    public Serializable insert(Object o) {
        return this.persist(o);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() {
        this.connected = false;
    }

    public Transaction beginTransaction() {
        throw new UnsupportedOperationException("Use HibernatePlatformTransactionManager instead");
    }

    public Transaction beginTransaction(TransactionDefinition definition) {
        throw new UnsupportedOperationException("Use HibernatePlatformTransactionManager instead");
    }

    public MappingContext getMappingContext() {
        return this.getDatastore().getMappingContext();
    }

    public Serializable persist(Object o) {
        return this.hibernateTemplate.save(o);
    }

    public void refresh(Object o) {
        this.hibernateTemplate.refresh(o);
    }

    public void attach(Object o) {
        this.hibernateTemplate.lock(o, LockMode.NONE);
    }

    public void flush() {
        this.hibernateTemplate.flush();
    }

    public void clear() {
        this.hibernateTemplate.clear();
    }

    public void clear(Object o) {
        this.hibernateTemplate.evict(o);
    }

    public boolean contains(Object o) {
        return this.hibernateTemplate.contains(o);
    }

    public void lock(Object o) {
        this.hibernateTemplate.lock(o, LockMode.PESSIMISTIC_WRITE);
    }

    public void unlock(Object o) {
    }

    public List<Serializable> persist(Iterable objects) {
        ArrayList<Serializable> identifiers = new ArrayList<Serializable>();
        for (Object object : objects) {
            identifiers.add(this.hibernateTemplate.save(object));
        }
        return identifiers;
    }

    public <T> T retrieve(Class<T> type, Serializable key) {
        return this.hibernateTemplate.get(type, key);
    }

    public <T> T proxy(Class<T> type, Serializable key) {
        return this.hibernateTemplate.load(type, key);
    }

    public <T> T lock(Class<T> type, Serializable key) {
        return this.hibernateTemplate.get(type, key, LockMode.PESSIMISTIC_WRITE);
    }

    public void delete(Iterable objects) {
        Collection list = this.getIterableAsCollection(objects);
        this.hibernateTemplate.deleteAll(list);
    }

    protected Collection getIterableAsCollection(Iterable objects) {
        ArrayList list;
        if (objects instanceof Collection) {
            list = (ArrayList)objects;
        } else {
            list = new ArrayList();
            for (Object object : objects) {
                list.add(object);
            }
        }
        return list;
    }

    public void delete(Object obj) {
        this.hibernateTemplate.delete(obj);
    }

    public List retrieveAll(Class type, Serializable ... keys) {
        return this.retrieveAll(type, Arrays.asList(keys));
    }

    public Persister getPersister(Object o) {
        return null;
    }

    public Transaction getTransaction() {
        throw new UnsupportedOperationException("Use HibernatePlatformTransactionManager instead");
    }

    public boolean hasTransaction() {
        Object resource = TransactionSynchronizationManager.getResource((Object)this.hibernateTemplate.getSessionFactory());
        return resource != null;
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public boolean isDirty(Object o) {
        return true;
    }

    public Object getNativeInterface() {
        return this.hibernateTemplate;
    }

    public void setSynchronizedWithTransaction(boolean synchronizedWithTransaction) {
    }
}

