/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.externalconfig;

import grails.plugin.externalconfig.WriteFilteringMap;
import grails.util.Environment;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.config.NavigableMapPropertySource;
import org.grails.config.PropertySourcesConfig;
import org.grails.config.yaml.YamlPropertySourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ExternalConfigRunListener
implements SpringApplicationRunListener,
GroovyObject {
    private ResourceLoader defaultResourceLoader;
    private YamlPropertySourceLoader yamlPropertySourceLoader;
    private Logger log;
    private String userHome;
    private String separator;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ExternalConfigRunListener(SpringApplication application, String ... args) {
        MetaClass metaClass;
        String string;
        String string2;
        Logger logger;
        YamlPropertySourceLoader yamlPropertySourceLoader;
        DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
        this.defaultResourceLoader = defaultResourceLoader;
        this.yamlPropertySourceLoader = yamlPropertySourceLoader = new YamlPropertySourceLoader();
        this.log = logger = LoggerFactory.getLogger((String)"grails.plugin.externalconfig.ExternalConfig");
        this.userHome = string2 = System.getProperties().getProperty("user.home");
        this.separator = string = System.getProperties().getProperty("file.separator");
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        List<Object> locations = this.getLocations(environment);
        String encoding = ShortTypeHandling.castToString((Object)environment.getProperty("grails.config.encoding", String.class, (Object)"UTF-8"));
        Object location2 = null;
        for (Object location2 : locations) {
            MapPropertySource mapPropertySource;
            MapPropertySource propertySource = null;
            Map currentProperties = ExternalConfigRunListener.getCurrentConfig(environment);
            if (location2 instanceof Class) {
                MapPropertySource mapPropertySource2;
                propertySource = mapPropertySource2 = this.loadClassConfig((Class)ScriptBytecodeAdapter.asType((Object)location2, Class.class), currentProperties);
            } else {
                String finalLocation = environment.resolvePlaceholders((String)ScriptBytecodeAdapter.asType((Object)location2, String.class));
                Resource resource = this.defaultResourceLoader.getResource(finalLocation);
                if (resource.exists()) {
                    if (finalLocation.endsWith(".groovy")) {
                        MapPropertySource mapPropertySource3;
                        propertySource = mapPropertySource3 = this.loadGroovyConfig(resource, encoding, currentProperties);
                    } else if (finalLocation.endsWith(".yml")) {
                        environment.getActiveProfiles();
                        NavigableMapPropertySource navigableMapPropertySource = this.loadYamlConfig(resource);
                        propertySource = navigableMapPropertySource;
                    } else {
                        MapPropertySource mapPropertySource4;
                        propertySource = mapPropertySource4 = this.loadPropertiesConfig(resource);
                    }
                } else {
                    this.log.debug("Config file {} not found", new Object[]{finalLocation});
                }
            }
            if (!(DefaultTypeTransformation.booleanUnbox((mapPropertySource = propertySource) != null ? mapPropertySource.getSource() : null) && !((Map)propertySource.getSource()).isEmpty())) continue;
            environment.getPropertySources().addFirst((PropertySource)propertySource);
        }
    }

    private List<Object> getLocations(ConfigurableEnvironment environment) {
        List locations = (List)environment.getProperty("grails.config.locations", List.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        String environmentString = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Environment.getCurrent().getName()}, new String[]{"environments.", ".grails.config.locations"}));
        Object object = environment.getProperty(environmentString, List.class, (Object)locations);
        locations = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        public class _getLocations_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getLocations_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object location) {
                if (location instanceof CharSequence) {
                    String string = ((ExternalConfigRunListener)this.getThisObject()).replaceUserHomePrefix((String)ScriptBytecodeAdapter.asType((Object)location, String.class));
                    location = string;
                    List<Object> expandedLocations = ((ExternalConfigRunListener)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ExternalConfigRunListener.class)).handleWildcardLocation((String)ScriptBytecodeAdapter.asType((Object)location, String.class));
                    if (DefaultTypeTransformation.booleanUnbox(expandedLocations)) {
                        return expandedLocations;
                    }
                }
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{location});
            }

            public Object call(Object location) {
                return this.doCall(location);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLocations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collectMany((Iterable)locations, (Closure)new _getLocations_closure1(this, this));
    }

    public List<Object> handleWildcardLocation(String location) {
        block8: {
            if (location.startsWith("file:")) {
                String locationFileName = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)StringGroovyMethods.tokenize((CharSequence)location, (CharSequence)this.separator), (int)-1));
                if (locationFileName.contains("*")) {
                    String parentLocation = StringGroovyMethods.minus((CharSequence)location, (Object)locationFileName);
                    Resource resource = this.defaultResourceLoader.getResource(parentLocation);
                    if (!(resource.getFile().exists() && resource.getFile().isDirectory())) break block8;
                    Path dir = resource.getFile().toPath();
                    DirectoryStream<Path> stream = Files.newDirectoryStream(dir, locationFileName);
                    public class _handleWildcardLocation_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _handleWildcardLocation_closure2(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Path p) {
                            return new GStringImpl(new Object[]{p.toAbsolutePath()}, new String[]{"file:", ""});
                        }

                        public Object call(Path p) {
                            return this.doCall(p);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _handleWildcardLocation_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    List list = DefaultGroovyMethods.collect(stream, (Closure)new _handleWildcardLocation_closure2(this, this));
                    try {
                        return list;
                    }
                    catch (FileNotFoundException ignore) {
                        List list2 = (List)ScriptBytecodeAdapter.castToType(null, List.class);
                        return list2;
                    }
                }
            }
        }
        return (List)ScriptBytecodeAdapter.castToType(null, List.class);
    }

    private String replaceUserHomePrefix(String location) {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.userHome) && location.startsWith("~/")) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.userHome, StringGroovyMethods.getAt((String)location, (IntRange)new IntRange(true, 1, Integer.valueOf(-1).intValue()))}, new String[]{"file:", "", ""});
            location = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return location;
    }

    private MapPropertySource loadClassConfig(Class location, Map currentConfig) {
        this.log.info("Loading config class {}", (Object)location.getName());
        ConfigSlurper slurper = new ConfigSlurper(Environment.getCurrent().getName());
        WriteFilteringMap filterMap = new WriteFilteringMap(currentConfig);
        WriteFilteringMap writeFilteringMap = filterMap;
        slurper.setBinding((Map)writeFilteringMap);
        ConfigObject configObject = slurper.parse(location);
        Map properties = configObject != null ? configObject.flatten() : null;
        Map<String, Object> writtenValues = filterMap.getWrittenValues();
        properties.putAll(writtenValues);
        return new MapPropertySource(location.toString(), properties);
    }

    private MapPropertySource loadGroovyConfig(Resource resource, String encoding, Map currentConfig) {
        ConfigObject configObject;
        this.log.info("Loading groovy config file {}", (Object)resource.getURI());
        String configText = IOGroovyMethods.getText((InputStream)resource.getInputStream(), (String)encoding);
        ConfigSlurper slurper = new ConfigSlurper(Environment.getCurrent().getName());
        WriteFilteringMap filterMap = new WriteFilteringMap(currentConfig);
        WriteFilteringMap writeFilteringMap = filterMap;
        slurper.setBinding((Map)writeFilteringMap);
        ConfigObject configObject2 = slurper.parse(configText);
        Map properties = DefaultTypeTransformation.booleanUnbox((Object)configText) ? ((configObject = configObject2) != null ? configObject.flatten() : null) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Map<String, Object> writtenValues = filterMap.getWrittenValues();
        properties.putAll(writtenValues);
        return new MapPropertySource(resource.getFilename(), properties);
    }

    private NavigableMapPropertySource loadYamlConfig(Resource resource) {
        this.log.info("Loading YAML config file {}", (Object)resource.getURI());
        NavigableMapPropertySource propertySource = (NavigableMapPropertySource)ScriptBytecodeAdapter.asType((Object)this.yamlPropertySourceLoader.load(resource.getFilename(), resource, null), NavigableMapPropertySource.class);
        return propertySource;
    }

    private MapPropertySource loadPropertiesConfig(Resource resource) {
        this.log.info("Loading properties config file {}", (Object)resource.getURI());
        Properties properties = new Properties();
        properties.load(resource.getInputStream());
        return new MapPropertySource(resource.getFilename(), (Map)properties);
    }

    public void starting() {
    }

    public void started() {
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void finished(ConfigurableApplicationContext context, Throwable exception) {
    }

    public static Map getCurrentConfig(ConfigurableEnvironment environment) {
        return new PropertySourcesConfig((PropertySources)environment.getPropertySources());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ExternalConfigRunListener.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

