/*
 * Decompiled with CFR 0.152.
 */
package eu.bitwalker.useragentutils;

import eu.bitwalker.useragentutils.BrowserType;
import eu.bitwalker.useragentutils.Manufacturer;
import eu.bitwalker.useragentutils.PatternBasedVersionFetcher;
import eu.bitwalker.useragentutils.RenderingEngine;
import eu.bitwalker.useragentutils.SequentialVersionFetcher;
import eu.bitwalker.useragentutils.Utils;
import eu.bitwalker.useragentutils.Version;
import eu.bitwalker.useragentutils.VersionFetcher;
import eu.bitwalker.useragentutils.VersionFetcherFromMap;
import eu.bitwalker.useragentutils.browser.SafariUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public enum Browser {
    OUTLOOK(Manufacturer.MICROSOFT, null, 100, "Outlook", new String[]{"MSOffice"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.WORD, new PatternBasedVersionFetcher("MSOffice (([0-9]+))")),
    OUTLOOK2007(Manufacturer.MICROSOFT, OUTLOOK, 107, "Outlook 2007", new String[]{"MSOffice 12"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.WORD, null),
    OUTLOOK2013(Manufacturer.MICROSOFT, OUTLOOK, 109, "Outlook 2013", new String[]{"Microsoft Outlook 15"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.WORD, null),
    OUTLOOK2010(Manufacturer.MICROSOFT, OUTLOOK, 108, "Outlook 2010", new String[]{"MSOffice 14", "Microsoft Outlook 14"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.WORD, null),
    IE(Manufacturer.MICROSOFT, null, 1, "Internet Explorer", new String[]{"MSIE", "Trident", "IE "}, new String[]{"BingPreview", "Xbox", "Xbox One"}, BrowserType.WEB_BROWSER, RenderingEngine.TRIDENT, new PatternBasedVersionFetcher("MSIE (([\\d]+)\\.([\\w]+))")),
    OUTLOOK_EXPRESS7(Manufacturer.MICROSOFT, IE, 110, "Windows Live Mail", new String[]{"Outlook-Express/7.0"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.TRIDENT, null),
    IEMOBILE11(Manufacturer.MICROSOFT, IE, 125, "IE Mobile 11", new String[]{"IEMobile/11"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.TRIDENT, new PatternBasedVersionFetcher("(?:Trident\\/7|IE)(?:\\.[0-9]*;)?(?:.*rv:| )(([0-9]+)\\.?([0-9]+))")),
    IEMOBILE10(Manufacturer.MICROSOFT, IE, 124, "IE Mobile 10", new String[]{"IEMobile/10"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.TRIDENT, null),
    IEMOBILE9(Manufacturer.MICROSOFT, IE, 123, "IE Mobile 9", new String[]{"IEMobile/9"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.TRIDENT, null),
    IEMOBILE7(Manufacturer.MICROSOFT, IE, 121, "IE Mobile 7", new String[]{"IEMobile 7"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.TRIDENT, null),
    IEMOBILE6(Manufacturer.MICROSOFT, IE, 120, "IE Mobile 6", new String[]{"IEMobile 6"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.TRIDENT, null),
    IE_XBOX(Manufacturer.MICROSOFT, IE, 360, "Xbox", new String[]{"xbox"}, new String[0], BrowserType.WEB_BROWSER, RenderingEngine.TRIDENT, null),
    IE11(Manufacturer.MICROSOFT, IE, 95, "Internet Explorer 11", new String[]{"Trident/7", "IE 11."}, new String[]{"MSIE 7", "BingPreview"}, BrowserType.WEB_BROWSER, RenderingEngine.TRIDENT, new PatternBasedVersionFetcher("(?:Trident\\/7|IE)(?:\\.[0-9]*;)?(?:.*rv:| )(([0-9]+)\\.?([0-9]+))")),
    IE10(Manufacturer.MICROSOFT, IE, 92, "Internet Explorer 10", new String[]{"MSIE 10"}, null, BrowserType.WEB_BROWSER, RenderingEngine.TRIDENT, null),
    IE9(Manufacturer.MICROSOFT, IE, 90, "Internet Explorer 9", new String[]{"MSIE 9"}, null, BrowserType.WEB_BROWSER, RenderingEngine.TRIDENT, null),
    IE8(Manufacturer.MICROSOFT, IE, 80, "Internet Explorer 8", new String[]{"MSIE 8"}, null, BrowserType.WEB_BROWSER, RenderingEngine.TRIDENT, null),
    IE7(Manufacturer.MICROSOFT, IE, 70, "Internet Explorer 7", new String[]{"MSIE 7"}, null, BrowserType.WEB_BROWSER, RenderingEngine.TRIDENT, null),
    IE6(Manufacturer.MICROSOFT, IE, 60, "Internet Explorer 6", new String[]{"MSIE 6"}, null, BrowserType.WEB_BROWSER, RenderingEngine.TRIDENT, null),
    IE5_5(Manufacturer.MICROSOFT, IE, 55, "Internet Explorer 5.5", new String[]{"MSIE 5.5"}, null, BrowserType.WEB_BROWSER, RenderingEngine.TRIDENT, null),
    IE5(Manufacturer.MICROSOFT, IE, 50, "Internet Explorer 5", new String[]{"MSIE 5"}, null, BrowserType.WEB_BROWSER, RenderingEngine.TRIDENT, null),
    EDGE(Manufacturer.MICROSOFT, null, 300, "Microsoft Edge", new String[]{"Edge"}, null, BrowserType.WEB_BROWSER, RenderingEngine.EDGE_HTML, new PatternBasedVersionFetcher("(?:Edge\\/(([0-9]+)\\.([0-9]*)))")),
    EDGE_MOBILE(Manufacturer.MICROSOFT, EDGE, 304, "Microsoft Edge Mobile", new String[]{"Mobile Safari"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.EDGE_HTML, null),
    EDGE_MOBILE15(Manufacturer.MICROSOFT, EDGE_MOBILE, 310, "Microsoft Edge Mobile (layout engine 15)", new String[]{"Edge/15"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.EDGE_HTML, null),
    EDGE_MOBILE14(Manufacturer.MICROSOFT, EDGE_MOBILE, 307, "Microsoft Edge Mobile (layout engine 14)", new String[]{"Edge/14"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.EDGE_HTML, null),
    EDGE_MOBILE13(Manufacturer.MICROSOFT, EDGE_MOBILE, 308, "Microsoft Edge Mobile (layout engine 13)", new String[]{"Edge/13"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.EDGE_HTML, null),
    EDGE_MOBILE12(Manufacturer.MICROSOFT, EDGE_MOBILE, 302, "Microsoft Edge Mobile (layout engine 12)", new String[]{"Edge/12"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.EDGE_HTML, null),
    EDGE16(Manufacturer.MICROSOFT, EDGE, 312, "Microsoft Edge (layout engine 16)", new String[]{"Edge/16"}, new String[]{"Mobile"}, BrowserType.WEB_BROWSER, RenderingEngine.EDGE_HTML, null),
    EDGE15(Manufacturer.MICROSOFT, EDGE, 309, "Microsoft Edge (layout engine 15)", new String[]{"Edge/15"}, new String[]{"Mobile"}, BrowserType.WEB_BROWSER, RenderingEngine.EDGE_HTML, null),
    EDGE14(Manufacturer.MICROSOFT, EDGE, 305, "Microsoft Edge (layout engine 14)", new String[]{"Edge/14"}, new String[]{"Mobile"}, BrowserType.WEB_BROWSER, RenderingEngine.EDGE_HTML, null),
    EDGE13(Manufacturer.MICROSOFT, EDGE, 303, "Microsoft Edge (layout engine 13)", new String[]{"Edge/13"}, new String[]{"Mobile"}, BrowserType.WEB_BROWSER, RenderingEngine.EDGE_HTML, null),
    EDGE12(Manufacturer.MICROSOFT, EDGE, 301, "Microsoft Edge (layout engine 12)", new String[]{"Edge/12"}, new String[]{"Mobile"}, BrowserType.WEB_BROWSER, RenderingEngine.EDGE_HTML, null),
    CHROME(Manufacturer.GOOGLE, null, 1, "Chrome", new String[]{"Chrome", "CrMo", "CriOS"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("Chrome\\/(([0-9]+)\\.?([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    CHROME_MOBILE(Manufacturer.GOOGLE, CHROME, 100, "Chrome Mobile", new String[]{"CrMo", "CriOS", "Mobile Safari"}, new String[]{"OPR/"}, BrowserType.MOBILE_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("(?:CriOS|CrMo|Chrome)\\/(([0-9]+)\\.?([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    CHROME65(Manufacturer.GOOGLE, CHROME, 71, "Chrome 65", new String[]{"Chrome/65"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME64(Manufacturer.GOOGLE, CHROME, 70, "Chrome 64", new String[]{"Chrome/64"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME63(Manufacturer.GOOGLE, CHROME, 69, "Chrome 63", new String[]{"Chrome/63"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME62(Manufacturer.GOOGLE, CHROME, 68, "Chrome 62", new String[]{"Chrome/62"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME61(Manufacturer.GOOGLE, CHROME, 67, "Chrome 61", new String[]{"Chrome/61"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME60(Manufacturer.GOOGLE, CHROME, 66, "Chrome 60", new String[]{"Chrome/60"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME59(Manufacturer.GOOGLE, CHROME, 65, "Chrome 59", new String[]{"Chrome/59"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME58(Manufacturer.GOOGLE, CHROME, 64, "Chrome 58", new String[]{"Chrome/58"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME57(Manufacturer.GOOGLE, CHROME, 63, "Chrome 57", new String[]{"Chrome/57"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME56(Manufacturer.GOOGLE, CHROME, 62, "Chrome 56", new String[]{"Chrome/56"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME55(Manufacturer.GOOGLE, CHROME, 61, "Chrome 55", new String[]{"Chrome/55"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME54(Manufacturer.GOOGLE, CHROME, 60, "Chrome 54", new String[]{"Chrome/54"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME53(Manufacturer.GOOGLE, CHROME, 59, "Chrome 53", new String[]{"Chrome/53"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME52(Manufacturer.GOOGLE, CHROME, 58, "Chrome 52", new String[]{"Chrome/52"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME51(Manufacturer.GOOGLE, CHROME, 57, "Chrome 51", new String[]{"Chrome/51"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME50(Manufacturer.GOOGLE, CHROME, 56, "Chrome 50", new String[]{"Chrome/50"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME49(Manufacturer.GOOGLE, CHROME, 55, "Chrome 49", new String[]{"Chrome/49"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME48(Manufacturer.GOOGLE, CHROME, 53, "Chrome 48", new String[]{"Chrome/48"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME47(Manufacturer.GOOGLE, CHROME, 52, "Chrome 47", new String[]{"Chrome/47"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME46(Manufacturer.GOOGLE, CHROME, 51, "Chrome 46", new String[]{"Chrome/46"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME45(Manufacturer.GOOGLE, CHROME, 50, "Chrome 45", new String[]{"Chrome/45"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME44(Manufacturer.GOOGLE, CHROME, 49, "Chrome 44", new String[]{"Chrome/44"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME43(Manufacturer.GOOGLE, CHROME, 48, "Chrome 43", new String[]{"Chrome/43"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME42(Manufacturer.GOOGLE, CHROME, 47, "Chrome 42", new String[]{"Chrome/42"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME41(Manufacturer.GOOGLE, CHROME, 46, "Chrome 41", new String[]{"Chrome/41"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME40(Manufacturer.GOOGLE, CHROME, 45, "Chrome 40", new String[]{"Chrome/40"}, new String[]{"OPR/", "Web Preview", "Vivaldi"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME39(Manufacturer.GOOGLE, CHROME, 44, "Chrome 39", new String[]{"Chrome/39"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME38(Manufacturer.GOOGLE, CHROME, 43, "Chrome 38", new String[]{"Chrome/38"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME37(Manufacturer.GOOGLE, CHROME, 42, "Chrome 37", new String[]{"Chrome/37"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME36(Manufacturer.GOOGLE, CHROME, 41, "Chrome 36", new String[]{"Chrome/36"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME35(Manufacturer.GOOGLE, CHROME, 40, "Chrome 35", new String[]{"Chrome/35"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME34(Manufacturer.GOOGLE, CHROME, 39, "Chrome 34", new String[]{"Chrome/34"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME33(Manufacturer.GOOGLE, CHROME, 38, "Chrome 33", new String[]{"Chrome/33"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME32(Manufacturer.GOOGLE, CHROME, 37, "Chrome 32", new String[]{"Chrome/32"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME31(Manufacturer.GOOGLE, CHROME, 36, "Chrome 31", new String[]{"Chrome/31"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME30(Manufacturer.GOOGLE, CHROME, 35, "Chrome 30", new String[]{"Chrome/30"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME29(Manufacturer.GOOGLE, CHROME, 34, "Chrome 29", new String[]{"Chrome/29"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME28(Manufacturer.GOOGLE, CHROME, 33, "Chrome 28", new String[]{"Chrome/28"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME27(Manufacturer.GOOGLE, CHROME, 32, "Chrome 27", new String[]{"Chrome/27"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME26(Manufacturer.GOOGLE, CHROME, 31, "Chrome 26", new String[]{"Chrome/26"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME25(Manufacturer.GOOGLE, CHROME, 30, "Chrome 25", new String[]{"Chrome/25"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME24(Manufacturer.GOOGLE, CHROME, 29, "Chrome 24", new String[]{"Chrome/24"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME23(Manufacturer.GOOGLE, CHROME, 28, "Chrome 23", new String[]{"Chrome/23"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME22(Manufacturer.GOOGLE, CHROME, 27, "Chrome 22", new String[]{"Chrome/22"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME21(Manufacturer.GOOGLE, CHROME, 26, "Chrome 21", new String[]{"Chrome/21"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME20(Manufacturer.GOOGLE, CHROME, 25, "Chrome 20", new String[]{"Chrome/20"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME19(Manufacturer.GOOGLE, CHROME, 24, "Chrome 19", new String[]{"Chrome/19"}, new String[]{"OPR/", "Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME18(Manufacturer.GOOGLE, CHROME, 23, "Chrome 18", new String[]{"Chrome/18"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME17(Manufacturer.GOOGLE, CHROME, 22, "Chrome 17", new String[]{"Chrome/17"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME16(Manufacturer.GOOGLE, CHROME, 21, "Chrome 16", new String[]{"Chrome/16"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME15(Manufacturer.GOOGLE, CHROME, 20, "Chrome 15", new String[]{"Chrome/15"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME14(Manufacturer.GOOGLE, CHROME, 19, "Chrome 14", new String[]{"Chrome/14"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME13(Manufacturer.GOOGLE, CHROME, 18, "Chrome 13", new String[]{"Chrome/13"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME12(Manufacturer.GOOGLE, CHROME, 17, "Chrome 12", new String[]{"Chrome/12"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME11(Manufacturer.GOOGLE, CHROME, 16, "Chrome 11", new String[]{"Chrome/11"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME10(Manufacturer.GOOGLE, CHROME, 15, "Chrome 10", new String[]{"Chrome/10"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME9(Manufacturer.GOOGLE, CHROME, 10, "Chrome 9", new String[]{"Chrome/9"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    CHROME8(Manufacturer.GOOGLE, CHROME, 5, "Chrome 8", new String[]{"Chrome/8"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    OMNIWEB(Manufacturer.OTHER, null, 2, "Omniweb", new String[]{"OmniWeb"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    FIREFOX(Manufacturer.MOZILLA, null, 10, "Firefox", new String[]{"Firefox", "FxiOS"}, new String[]{"camino", "flock", "ggpht.com", "WordPress.com mShots"}, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, new PatternBasedVersionFetcher("Firefox\\/(([0-9]+)\\.?([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    FIREFOX3MOBILE(Manufacturer.MOZILLA, FIREFOX, 31, "Firefox 3 Mobile", new String[]{"Firefox/3.5 Maemo"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX_MOBILE(Manufacturer.MOZILLA, FIREFOX, 200, "Firefox Mobile", new String[]{"Mobile"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX_MOBILE23(Manufacturer.MOZILLA, FIREFOX_MOBILE, 223, "Firefox Mobile 23", new String[]{"Firefox/23"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX_MOBILE_IOS(Manufacturer.MOZILLA, FIREFOX_MOBILE, 224, "Firefox Mobile (iOS)", new String[]{"FxiOS"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.WEBKIT, null),
    FIREFOX59(Manufacturer.MOZILLA, FIREFOX, 238, "Firefox 59", new String[]{"Firefox/59"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX58(Manufacturer.MOZILLA, FIREFOX, 237, "Firefox 58", new String[]{"Firefox/58"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX57(Manufacturer.MOZILLA, FIREFOX, 236, "Firefox 57", new String[]{"Firefox/57"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX56(Manufacturer.MOZILLA, FIREFOX, 235, "Firefox 56", new String[]{"Firefox/56"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX55(Manufacturer.MOZILLA, FIREFOX, 234, "Firefox 55", new String[]{"Firefox/55"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX54(Manufacturer.MOZILLA, FIREFOX, 233, "Firefox 54", new String[]{"Firefox/54"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX53(Manufacturer.MOZILLA, FIREFOX, 232, "Firefox 53", new String[]{"Firefox/53"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX52(Manufacturer.MOZILLA, FIREFOX, 231, "Firefox 52", new String[]{"Firefox/52"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX51(Manufacturer.MOZILLA, FIREFOX, 230, "Firefox 51", new String[]{"Firefox/51"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX50(Manufacturer.MOZILLA, FIREFOX, 229, "Firefox 50", new String[]{"Firefox/50"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX49(Manufacturer.MOZILLA, FIREFOX, 228, "Firefox 49", new String[]{"Firefox/49"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX48(Manufacturer.MOZILLA, FIREFOX, 227, "Firefox 48", new String[]{"Firefox/48"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX47(Manufacturer.MOZILLA, FIREFOX, 226, "Firefox 47", new String[]{"Firefox/47"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX46(Manufacturer.MOZILLA, FIREFOX, 225, "Firefox 46", new String[]{"Firefox/46"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX45(Manufacturer.MOZILLA, FIREFOX, 222, "Firefox 45", new String[]{"Firefox/45"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX44(Manufacturer.MOZILLA, FIREFOX, 221, "Firefox 44", new String[]{"Firefox/44"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX43(Manufacturer.MOZILLA, FIREFOX, 220, "Firefox 43", new String[]{"Firefox/43"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX42(Manufacturer.MOZILLA, FIREFOX, 219, "Firefox 42", new String[]{"Firefox/42"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX41(Manufacturer.MOZILLA, FIREFOX, 218, "Firefox 41", new String[]{"Firefox/41"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX40(Manufacturer.MOZILLA, FIREFOX, 217, "Firefox 40", new String[]{"Firefox/40"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX39(Manufacturer.MOZILLA, FIREFOX, 216, "Firefox 39", new String[]{"Firefox/39"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX38(Manufacturer.MOZILLA, FIREFOX, 215, "Firefox 38", new String[]{"Firefox/38"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX37(Manufacturer.MOZILLA, FIREFOX, 214, "Firefox 37", new String[]{"Firefox/37"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX36(Manufacturer.MOZILLA, FIREFOX, 213, "Firefox 36", new String[]{"Firefox/36"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX35(Manufacturer.MOZILLA, FIREFOX, 212, "Firefox 35", new String[]{"Firefox/35"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX34(Manufacturer.MOZILLA, FIREFOX, 211, "Firefox 34", new String[]{"Firefox/34"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX33(Manufacturer.MOZILLA, FIREFOX, 210, "Firefox 33", new String[]{"Firefox/33"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX32(Manufacturer.MOZILLA, FIREFOX, 109, "Firefox 32", new String[]{"Firefox/32"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX31(Manufacturer.MOZILLA, FIREFOX, 310, "Firefox 31", new String[]{"Firefox/31"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX30(Manufacturer.MOZILLA, FIREFOX, 300, "Firefox 30", new String[]{"Firefox/30"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX29(Manufacturer.MOZILLA, FIREFOX, 290, "Firefox 29", new String[]{"Firefox/29"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX28(Manufacturer.MOZILLA, FIREFOX, 280, "Firefox 28", new String[]{"Firefox/28"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX27(Manufacturer.MOZILLA, FIREFOX, 108, "Firefox 27", new String[]{"Firefox/27"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX26(Manufacturer.MOZILLA, FIREFOX, 107, "Firefox 26", new String[]{"Firefox/26"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX25(Manufacturer.MOZILLA, FIREFOX, 106, "Firefox 25", new String[]{"Firefox/25"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX24(Manufacturer.MOZILLA, FIREFOX, 105, "Firefox 24", new String[]{"Firefox/24"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX23(Manufacturer.MOZILLA, FIREFOX, 104, "Firefox 23", new String[]{"Firefox/23"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX22(Manufacturer.MOZILLA, FIREFOX, 103, "Firefox 22", new String[]{"Firefox/22"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX21(Manufacturer.MOZILLA, FIREFOX, 102, "Firefox 21", new String[]{"Firefox/21"}, new String[]{"WordPress.com mShots"}, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX20(Manufacturer.MOZILLA, FIREFOX, 101, "Firefox 20", new String[]{"Firefox/20"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX19(Manufacturer.MOZILLA, FIREFOX, 100, "Firefox 19", new String[]{"Firefox/19"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX18(Manufacturer.MOZILLA, FIREFOX, 99, "Firefox 18", new String[]{"Firefox/18"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX17(Manufacturer.MOZILLA, FIREFOX, 98, "Firefox 17", new String[]{"Firefox/17"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX16(Manufacturer.MOZILLA, FIREFOX, 97, "Firefox 16", new String[]{"Firefox/16"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX15(Manufacturer.MOZILLA, FIREFOX, 96, "Firefox 15", new String[]{"Firefox/15"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX14(Manufacturer.MOZILLA, FIREFOX, 95, "Firefox 14", new String[]{"Firefox/14"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX13(Manufacturer.MOZILLA, FIREFOX, 94, "Firefox 13", new String[]{"Firefox/13"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX12(Manufacturer.MOZILLA, FIREFOX, 93, "Firefox 12", new String[]{"Firefox/12"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX11(Manufacturer.MOZILLA, FIREFOX, 92, "Firefox 11", new String[]{"Firefox/11"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX10(Manufacturer.MOZILLA, FIREFOX, 91, "Firefox 10", new String[]{"Firefox/10"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX9(Manufacturer.MOZILLA, FIREFOX, 90, "Firefox 9", new String[]{"Firefox/9"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX8(Manufacturer.MOZILLA, FIREFOX, 80, "Firefox 8", new String[]{"Firefox/8"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX7(Manufacturer.MOZILLA, FIREFOX, 70, "Firefox 7", new String[]{"Firefox/7"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX6(Manufacturer.MOZILLA, FIREFOX, 60, "Firefox 6", new String[]{"Firefox/6."}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX5(Manufacturer.MOZILLA, FIREFOX, 50, "Firefox 5", new String[]{"Firefox/5."}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX4(Manufacturer.MOZILLA, FIREFOX, 40, "Firefox 4", new String[]{"Firefox/4."}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX3(Manufacturer.MOZILLA, FIREFOX, 30, "Firefox 3", new String[]{"Firefox/3."}, new String[]{"Camino", "Flock", "ggpht.com"}, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX2(Manufacturer.MOZILLA, FIREFOX, 20, "Firefox 2", new String[]{"Firefox/2."}, new String[]{"Camino", "WordPress.com mShots"}, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FIREFOX1_5(Manufacturer.MOZILLA, FIREFOX, 15, "Firefox 1.5", new String[]{"Firefox/1.5"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    SAFARI(Manufacturer.APPLE, null, 1, "Safari", new String[]{"Safari"}, new String[]{"bot", "preview", "OPR/", "Coast/", "Vivaldi", "CFNetwork", "Phantom"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new SequentialVersionFetcher(new PatternBasedVersionFetcher("Version\\/(([0-9]+)\\.?([\\w]+)?(\\.[\\w]+)?)"), new VersionFetcherFromMap(Pattern.compile("AppleWebKit/(\\d+(?:.\\d+){1,2})"), SafariUtils.getWebKitToSafariVersion()))),
    BLACKBERRY10(Manufacturer.BLACKBERRY, SAFARI, 10, "BlackBerry", new String[]{"BB10"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.WEBKIT, null),
    MOBILE_SAFARI(Manufacturer.APPLE, SAFARI, 2, "Mobile Safari", new String[]{"Mobile Safari", "Mobile/"}, new String[]{"bot", "preview", "OPR/", "Coast/", "Vivaldi", "CFNetwork", "FxiOS"}, BrowserType.MOBILE_BROWSER, RenderingEngine.WEBKIT, null),
    SILK(Manufacturer.AMAZON, SAFARI, 15, "Silk", new String[]{"Silk/"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("Silk\\/(([0-9]+)\\.?([\\w]+)?(\\.[\\w]+)?(\\-[\\w]+)?)")),
    SAFARI11(Manufacturer.APPLE, SAFARI, 12, "Safari 11", new String[]{"Version/11"}, new String[]{"bot"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    SAFARI10(Manufacturer.APPLE, SAFARI, 11, "Safari 10", new String[]{"Version/10"}, new String[]{"bot"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    SAFARI9(Manufacturer.APPLE, SAFARI, 9, "Safari 9", new String[]{"Version/9"}, new String[]{"bot"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    SAFARI8(Manufacturer.APPLE, SAFARI, 8, "Safari 8", new String[]{"Version/8"}, new String[]{"bot"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    SAFARI7(Manufacturer.APPLE, SAFARI, 7, "Safari 7", new String[]{"Version/7"}, new String[]{"bing"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    SAFARI6(Manufacturer.APPLE, SAFARI, 6, "Safari 6", new String[]{"Version/6"}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    SAFARI5(Manufacturer.APPLE, SAFARI, 3, "Safari 5", new String[]{"Version/5", "AppleWebKit/533", "AppleWebKit/534"}, new String[]{"Google Web Preview"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    SAFARI4(Manufacturer.APPLE, SAFARI, 4, "Safari 4", new String[]{"Version/4"}, new String[]{"Googlebot-Mobile"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    COAST(Manufacturer.OPERA, null, 500, "Opera", new String[]{" Coast/"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("Coast\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    COAST1(Manufacturer.OPERA, COAST, 501, "Opera", new String[]{" Coast/1."}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("Coast\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA(Manufacturer.OPERA, null, 1, "Opera", new String[]{" OPR/", "Opera"}, null, BrowserType.WEB_BROWSER, RenderingEngine.PRESTO, new PatternBasedVersionFetcher("[o][p][e]?[r][a]?\\/(([\\d]+)\\.([\\w]+)(\\.([\\w]+))?(\\.([\\w]+))?)")),
    OPERA_MOBILE(Manufacturer.OPERA, OPERA, 100, "Opera Mobile", new String[]{"Mobile Safari"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.BLINK, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA_MINI(Manufacturer.OPERA, OPERA, 20, "Opera Mini", new String[]{"Opera Mini"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.PRESTO, null),
    OPERA51(Manufacturer.OPERA, OPERA, 51, "Opera 51", new String[]{"OPR/51."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA50(Manufacturer.OPERA, OPERA, 50, "Opera 50", new String[]{"OPR/50."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA49(Manufacturer.OPERA, OPERA, 49, "Opera 49", new String[]{"OPR/49."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA48(Manufacturer.OPERA, OPERA, 48, "Opera 48", new String[]{"OPR/48."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA47(Manufacturer.OPERA, OPERA, 47, "Opera 47", new String[]{"OPR/47."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA46(Manufacturer.OPERA, OPERA, 46, "Opera 46", new String[]{"OPR/46."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA45(Manufacturer.OPERA, OPERA, 45, "Opera 45", new String[]{"OPR/45."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA44(Manufacturer.OPERA, OPERA, 44, "Opera 44", new String[]{"OPR/44."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA43(Manufacturer.OPERA, OPERA, 43, "Opera 43", new String[]{"OPR/43."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA42(Manufacturer.OPERA, OPERA, 42, "Opera 42", new String[]{"OPR/42."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA34(Manufacturer.OPERA, OPERA, 34, "Opera 34", new String[]{"OPR/34."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA33(Manufacturer.OPERA, OPERA, 33, "Opera 33", new String[]{"OPR/33."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA32(Manufacturer.OPERA, OPERA, 32, "Opera 32", new String[]{"OPR/32."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA31(Manufacturer.OPERA, OPERA, 31, "Opera 31", new String[]{"OPR/31."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA30(Manufacturer.OPERA, OPERA, 30, "Opera 30", new String[]{"OPR/30."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA29(Manufacturer.OPERA, OPERA, 29, "Opera 29", new String[]{"OPR/29."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA28(Manufacturer.OPERA, OPERA, 28, "Opera 28", new String[]{"OPR/28."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA27(Manufacturer.OPERA, OPERA, 27, "Opera 27", new String[]{"OPR/27."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA26(Manufacturer.OPERA, OPERA, 26, "Opera 26", new String[]{"OPR/26."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA25(Manufacturer.OPERA, OPERA, 25, "Opera 25", new String[]{"OPR/25."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA24(Manufacturer.OPERA, OPERA, 24, "Opera 24", new String[]{"OPR/24."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA23(Manufacturer.OPERA, OPERA, 23, "Opera 23", new String[]{"OPR/23."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA20(Manufacturer.OPERA, OPERA, 21, "Opera 20", new String[]{"OPR/20."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA19(Manufacturer.OPERA, OPERA, 19, "Opera 19", new String[]{"OPR/19."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA18(Manufacturer.OPERA, OPERA, 18, "Opera 18", new String[]{"OPR/18."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA17(Manufacturer.OPERA, OPERA, 17, "Opera 17", new String[]{"OPR/17."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA16(Manufacturer.OPERA, OPERA, 16, "Opera 16", new String[]{"OPR/16."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA15(Manufacturer.OPERA, OPERA, 15, "Opera 15", new String[]{"OPR/15."}, null, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, new PatternBasedVersionFetcher("OPR\\/(([\\d]+)\\.([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    OPERA12(Manufacturer.OPERA, OPERA, 12, "Opera 12", new String[]{"Opera/12", "Version/12."}, null, BrowserType.WEB_BROWSER, RenderingEngine.PRESTO, new PatternBasedVersionFetcher("Version\\/(([\\d]+)\\.([\\w]+))")),
    OPERA11(Manufacturer.OPERA, OPERA, 11, "Opera 11", new String[]{"Version/11."}, null, BrowserType.WEB_BROWSER, RenderingEngine.PRESTO, new PatternBasedVersionFetcher("Version\\/(([\\d]+)\\.([\\w]+))")),
    OPERA10(Manufacturer.OPERA, OPERA, 10, "Opera 10", new String[]{"Opera/9.8"}, null, BrowserType.WEB_BROWSER, RenderingEngine.PRESTO, new PatternBasedVersionFetcher("Version\\/(([\\d]+)\\.([\\w]+))")),
    OPERA9(Manufacturer.OPERA, OPERA, 5, "Opera 9", new String[]{"Opera/9"}, null, BrowserType.WEB_BROWSER, RenderingEngine.PRESTO, null),
    KONQUEROR(Manufacturer.OTHER, null, 1, "Konqueror", new String[]{"Konqueror"}, new String[]{"Exabot"}, BrowserType.WEB_BROWSER, RenderingEngine.KHTML, new PatternBasedVersionFetcher("Konqueror\\/(([0-9]+)\\.?([\\w]+)?(-[\\w]+)?)")),
    DOLFIN2(Manufacturer.SAMSUNG, null, 1, "Samsung Dolphin 2", new String[]{"Dolfin/2"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.WEBKIT, null),
    APPLE_WEB_KIT(Manufacturer.APPLE, null, 50, "Apple WebKit", new String[]{"AppleWebKit"}, new String[]{"bot", "preview", "OPR/", "Coast/", "Vivaldi", "Phantom"}, BrowserType.WEB_BROWSER, RenderingEngine.WEBKIT, null),
    APPLE_ITUNES(Manufacturer.APPLE, APPLE_WEB_KIT, 52, "iTunes", new String[]{"iTunes"}, null, BrowserType.APP, RenderingEngine.WEBKIT, null),
    APPLE_APPSTORE(Manufacturer.APPLE, APPLE_WEB_KIT, 53, "App Store", new String[]{"MacAppStore"}, null, BrowserType.APP, RenderingEngine.WEBKIT, null),
    ADOBE_AIR(Manufacturer.ADOBE, APPLE_WEB_KIT, 1, "Adobe AIR application", new String[]{"AdobeAIR"}, null, BrowserType.APP, RenderingEngine.WEBKIT, null),
    LOTUS_NOTES(Manufacturer.OTHER, null, 3, "Lotus Notes", new String[]{"Lotus-Notes"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.OTHER, new PatternBasedVersionFetcher("Lotus-Notes\\/(([\\d]+)\\.([\\w]+))")),
    CAMINO(Manufacturer.OTHER, null, 5, "Camino", new String[]{"Camino"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, new PatternBasedVersionFetcher("Camino\\/(([0-9]+)\\.?([\\w]+)?(\\.[\\w]+)?)")),
    CAMINO2(Manufacturer.OTHER, CAMINO, 17, "Camino 2", new String[]{"Camino/2"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, null),
    FLOCK(Manufacturer.OTHER, null, 4, "Flock", new String[]{"Flock"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, new PatternBasedVersionFetcher("Flock\\/(([0-9]+)\\.?([\\w]+)?(\\.[\\w]+)?)")),
    THUNDERBIRD(Manufacturer.MOZILLA, null, 110, "Thunderbird", new String[]{"Thunderbird"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.GECKO, new PatternBasedVersionFetcher("Thunderbird\\/(([0-9]+)\\.?([\\w]+)?(\\.[\\w]+)?(\\.[\\w]+)?)")),
    THUNDERBIRD12(Manufacturer.MOZILLA, THUNDERBIRD, 185, "Thunderbird 12", new String[]{"Thunderbird/12"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.GECKO, null),
    THUNDERBIRD11(Manufacturer.MOZILLA, THUNDERBIRD, 184, "Thunderbird 11", new String[]{"Thunderbird/11"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.GECKO, null),
    THUNDERBIRD10(Manufacturer.MOZILLA, THUNDERBIRD, 183, "Thunderbird 10", new String[]{"Thunderbird/10"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.GECKO, null),
    THUNDERBIRD8(Manufacturer.MOZILLA, THUNDERBIRD, 180, "Thunderbird 8", new String[]{"Thunderbird/8"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.GECKO, null),
    THUNDERBIRD7(Manufacturer.MOZILLA, THUNDERBIRD, 170, "Thunderbird 7", new String[]{"Thunderbird/7"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.GECKO, null),
    THUNDERBIRD6(Manufacturer.MOZILLA, THUNDERBIRD, 160, "Thunderbird 6", new String[]{"Thunderbird/6"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.GECKO, null),
    THUNDERBIRD3(Manufacturer.MOZILLA, THUNDERBIRD, 130, "Thunderbird 3", new String[]{"Thunderbird/3"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.GECKO, null),
    THUNDERBIRD2(Manufacturer.MOZILLA, THUNDERBIRD, 120, "Thunderbird 2", new String[]{"Thunderbird/2"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.GECKO, null),
    VIVALDI(Manufacturer.OTHER, null, 108338, "Vivaldi", new String[]{"Vivaldi"}, new String[0], BrowserType.WEB_BROWSER, RenderingEngine.BLINK, new PatternBasedVersionFetcher("Vivaldi/(([\\d]+).([\\d]+).([\\d]+).([\\d]+))")),
    SEAMONKEY(Manufacturer.OTHER, null, 15, "SeaMonkey", new String[]{"SeaMonkey"}, null, BrowserType.WEB_BROWSER, RenderingEngine.GECKO, new PatternBasedVersionFetcher("SeaMonkey\\/(([0-9]+)\\.?([\\w]+)?(\\.[\\w]+)?)")),
    BOT(Manufacturer.OTHER, null, 12, "Robot/Spider", new String[]{"Googlebot", "Mediapartners-Google", "Web Preview", "bot", "Applebot", "spider", "crawler", "Feedfetcher", "Slurp", "Twiceler", "Nutch", "BecomeBot", "bingbot", "BingPreview", "Google Web Preview", "WordPress.com mShots", "Seznam", "facebookexternalhit", "YandexMarket", "Teoma", "ThumbSniper", "Phantom", "Go-http-client", "Java/", "python-requests", "YandexBot", "AdsBot-Google", "AhrefsBot"}, null, BrowserType.ROBOT, RenderingEngine.OTHER, null),
    BOT_MOBILE(Manufacturer.OTHER, BOT, 20, "Mobile Robot/Spider", new String[]{"Googlebot-Mobile"}, null, BrowserType.ROBOT, RenderingEngine.OTHER, null),
    MOZILLA(Manufacturer.MOZILLA, null, 1, "Mozilla", new String[]{"Mozilla", "Moozilla"}, new String[]{"ggpht.com"}, BrowserType.WEB_BROWSER, RenderingEngine.OTHER, null),
    CFNETWORK(Manufacturer.OTHER, null, 6, "CFNetwork", new String[]{"CFNetwork"}, null, BrowserType.UNKNOWN, RenderingEngine.OTHER, new PatternBasedVersionFetcher("CFNetwork/(([\\d]+)(?:\\.([\\d]))?(?:\\.([\\d]+))?)")),
    EUDORA(Manufacturer.OTHER, null, 7, "Eudora", new String[]{"Eudora", "EUDORA"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.OTHER, null),
    POCOMAIL(Manufacturer.OTHER, null, 8, "PocoMail", new String[]{"PocoMail"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.OTHER, null),
    THEBAT(Manufacturer.OTHER, null, 9, "The Bat!", new String[]{"The Bat"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.OTHER, null),
    NETFRONT(Manufacturer.OTHER, null, 10, "NetFront", new String[]{"NetFront"}, null, BrowserType.MOBILE_BROWSER, RenderingEngine.OTHER, null),
    EVOLUTION(Manufacturer.OTHER, null, 11, "Evolution", new String[]{"CamelHttpStream"}, null, BrowserType.EMAIL_CLIENT, RenderingEngine.OTHER, null),
    LYNX(Manufacturer.OTHER, null, 13, "Lynx", new String[]{"Lynx"}, null, BrowserType.TEXT_BROWSER, RenderingEngine.OTHER, new PatternBasedVersionFetcher("Lynx\\/(([0-9]+)\\.([\\d]+)\\.?([\\w-+]+)?\\.?([\\w-+]+)?)")),
    DOWNLOAD(Manufacturer.OTHER, null, 16, "Downloading Tool", new String[]{"cURL", "wget", "ggpht.com", "Apache-HttpClient"}, null, BrowserType.TOOL, RenderingEngine.OTHER, null),
    UNKNOWN(Manufacturer.OTHER, null, 14, "Unknown", new String[0], null, BrowserType.UNKNOWN, RenderingEngine.OTHER, null),
    APPLE_MAIL(Manufacturer.APPLE, null, 51, "Apple Mail", new String[0], null, BrowserType.EMAIL_CLIENT, RenderingEngine.WEBKIT, null);

    private final short id;
    private final String name;
    private final String[] aliases;
    private final String[] excludeList;
    private final BrowserType browserType;
    private final Manufacturer manufacturer;
    private final RenderingEngine renderingEngine;
    private final Browser parent;
    private List<Browser> children;
    private VersionFetcher versionFetcher;
    private static List<Browser> topLevelBrowsers;

    private Browser(Manufacturer manufacturer, Browser parent, int versionId, String name, String[] aliases, String[] exclude, BrowserType browserType, RenderingEngine renderingEngine, VersionFetcher versionFetcher) {
        this.id = (short)((manufacturer.getId() << 8) + (byte)versionId);
        this.name = name;
        this.parent = parent;
        this.children = new ArrayList<Browser>();
        this.aliases = Utils.toLowerCase(aliases);
        this.excludeList = Utils.toLowerCase(exclude);
        this.browserType = browserType;
        this.manufacturer = manufacturer;
        this.renderingEngine = renderingEngine;
        this.versionFetcher = versionFetcher;
        if (this.parent == null) {
            Browser.addTopLevelBrowser(this);
        } else {
            this.parent.children.add(this);
        }
    }

    private static void addTopLevelBrowser(Browser browser) {
        if (topLevelBrowsers == null) {
            topLevelBrowsers = new ArrayList<Browser>();
        }
        topLevelBrowsers.add(browser);
    }

    public short getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion(String userAgentString) {
        if (this.versionFetcher == null) {
            return this.getGroup() != this ? this.getGroup().getVersion(userAgentString) : null;
        }
        return this.versionFetcher.version(userAgentString);
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public Manufacturer getManufacturer() {
        return this.manufacturer;
    }

    public RenderingEngine getRenderingEngine() {
        return this.renderingEngine;
    }

    public Browser getGroup() {
        if (this.parent != null) {
            return this.parent.getGroup();
        }
        return this;
    }

    public boolean isInUserAgentString(String agentString) {
        if (agentString == null) {
            return false;
        }
        String agentStringLowerCase = agentString.toLowerCase();
        return this.isInUserAgentLowercaseString(agentStringLowerCase);
    }

    private boolean isInUserAgentLowercaseString(String agentStringLowerCase) {
        return Utils.contains(agentStringLowerCase, this.aliases);
    }

    private Browser checkUserAgentLowercase(String agentLowercaseString) {
        if (this.isInUserAgentLowercaseString(agentLowercaseString)) {
            if (this.children.size() > 0) {
                for (Browser childBrowser : this.children) {
                    Browser match = childBrowser.checkUserAgentLowercase(agentLowercaseString);
                    if (match == null) continue;
                    return match;
                }
            }
            if (!Utils.contains(agentLowercaseString, this.excludeList)) {
                return this;
            }
        }
        return null;
    }

    public static Browser parseUserAgentString(String agentString) {
        return Browser.parseUserAgentString(agentString, topLevelBrowsers);
    }

    public static Browser parseUserAgentLowercaseString(String agentString) {
        if (agentString == null) {
            return UNKNOWN;
        }
        return Browser.parseUserAgentLowercaseString(agentString, topLevelBrowsers);
    }

    public static Browser parseUserAgentString(String agentString, List<Browser> browsers) {
        if (agentString != null) {
            String agentLowercaseString = agentString.toLowerCase();
            return Browser.parseUserAgentLowercaseString(agentLowercaseString, browsers);
        }
        return UNKNOWN;
    }

    private static Browser parseUserAgentLowercaseString(String agentLowercaseString, List<Browser> browsers) {
        for (Browser browser : browsers) {
            Browser match = browser.checkUserAgentLowercase(agentLowercaseString);
            if (match == null) continue;
            return match;
        }
        return UNKNOWN;
    }

    public static Browser valueOf(short id) {
        for (Browser browser : Browser.values()) {
            if (browser.getId() != id) continue;
            return browser;
        }
        throw new IllegalArgumentException("No enum const for id " + id);
    }
}

