/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.docx4j.Docx4jProperties;
import org.docx4j.Version;

public class MainDocumentPartFilterOutputStream
extends FilterOutputStream {
    boolean isNewPkg = true;
    boolean commentWritten = false;

    public MainDocumentPartFilterOutputStream(OutputStream out, boolean isNewPkg) {
        super(out);
        this.isNewPkg = isNewPkg;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.commentWritten) {
            super.write(b, off, len);
            return;
        }
        if (Docx4jProperties.getProperty("docx4j.jaxb.marshal.suppressVersionComment", false)) {
            this.commentWritten = true;
            super.write(b, off, len);
            return;
        }
        String text = new String(b, off, len, "UTF-8");
        int pos = text.indexOf("<w:body>");
        if (pos < 0) {
            super.write(b, off, len);
            return;
        }
        int bodyEnd = pos + 8;
        String bodyString = text.substring(0, bodyEnd);
        this.out.write(bodyString.getBytes("UTF-8"));
        String comment = "<!-- " + Version.getPoweredBy(this.isNewPkg) + " -->";
        this.out.write(comment.getBytes("UTF-8"));
        this.out.write(text.substring(bodyEnd).getBytes("UTF-8"));
        this.commentWritten = true;
    }
}

