/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.processors;

import asset.pipeline.AssetCompiler;
import asset.pipeline.AssetFile;
import asset.pipeline.AssetHelper;
import asset.pipeline.AssetPipelineConfigHolder;
import asset.pipeline.CacheManager;
import asset.pipeline.GenericAssetFile;
import asset.pipeline.processors.AbstractUrlRewritingProcessor;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class JsRequireProcessor
extends AbstractUrlRewritingProcessor {
    private static final Pattern URL_CALL_PATTERN;
    public static ThreadLocal<Map<String, String>> commonJsModules;
    public static ThreadLocal<String> baseModule;
    private static final String requireMethod = "\nvar _asset_pipeline_loaded_modules = _asset_pipeline_loaded_modules || {};\nvar _asset_pipeline_require = function(path) {\n\tvar loadedModule = _asset_pipeline_loaded_modules[path];\n\tif(loadedModule != undefined) {\n\t\treturn loadedModule.exports;\n\t}\n\tvar module = _asset_pipeline_modules[path];\n\tif(module != undefined) {\n\t\t_asset_pipeline_loaded_modules[path] = module();\n\t\treturn _asset_pipeline_loaded_modules[path].exports;\n\t}\n\treturn null;\n};\n\n";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public JsRequireProcessor(AssetCompiler precompiler) {
        super(precompiler);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"[^\\.a-zA-Z_\\-0-9]require\\((?:\\s*)(['\"]?)([a-zA-Z0-9\\-_.:/@#?$ &+%=]++)\\1?(?:\\s*)\\)");
        URL_CALL_PATTERN = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
        ThreadLocal threadLocal = new ThreadLocal();
        commonJsModules = threadLocal;
        ThreadLocal threadLocal2 = new ThreadLocal();
        baseModule = threadLocal2;
        AbstractUrlRewritingProcessor.doNotInsertCacheDigestIntoUrlForCompiledExtension("html");
    }

    @Override
    public String process(String inputText, AssetFile assetFile) {
        Boolean bl;
        String string;
        Reference assetFile2 = new Reference((Object)assetFile);
        if (AssetPipelineConfigHolder.getConfig() != null && ScriptBytecodeAdapter.compareEqual(AssetPipelineConfigHolder.getConfig().get("commonJs"), (Object)false)) {
            return inputText;
        }
        Reference cachedPaths = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        Boolean originator = false;
        if (!DefaultTypeTransformation.booleanUnbox((Object)baseModule.get())) {
            baseModule.set(((AssetFile)assetFile2.get()).getPath());
            boolean bl2 = true;
            originator = bl2;
            commonJsModules.set(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        }
        try {
            public class _process_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference cachedPaths;
                private /* synthetic */ Reference assetFile;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _process_closure1(Object _outerInstance, Object _thisObject, Reference cachedPaths, Reference assetFile) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.cachedPaths = reference2 = cachedPaths;
                    this.assetFile = reference = assetFile;
                }

                public Object doCall(String urlCall, String quote, String assetPath) {
                    Boolean cacheFound = ((LinkedHashMap)this.cachedPaths.get()).containsKey(assetPath);
                    String cachedPath = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.cachedPaths.get(), Map.class)), (Object)assetPath));
                    Integer requirePosition = urlCall.indexOf("require");
                    String resultPrefix = "";
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)requirePosition, (Object)0)) {
                        String string;
                        resultPrefix = string = urlCall.substring(0, requirePosition);
                    }
                    Object replacementPath = null;
                    Boolean bl = cacheFound;
                    if (bl == null ? false : bl) {
                        if (cachedPath == null) {
                            return StringGroovyMethods.plus((String)resultPrefix, (CharSequence)new GStringImpl(new Object[]{quote, assetPath, quote}, new String[]{"require(", "", "", ")"}));
                        }
                        return StringGroovyMethods.plus((String)resultPrefix, (CharSequence)new GStringImpl(new Object[]{quote, cachedPath, quote}, new String[]{"_asset_pipeline_require(", "", "", ")"}));
                    }
                    if (StringGroovyMethods.size((String)assetPath) > 0) {
                        AssetFile currFile = null;
                        if (!assetPath.startsWith("/") && ((AssetFile)this.assetFile.get()).getParentPath() != null) {
                            AssetFile assetFile;
                            String string;
                            String relativeFileName = DefaultGroovyMethods.join((Iterable)ScriptBytecodeAdapter.createList((Object[])new Object[]{((AssetFile)this.assetFile.get()).getParentPath(), assetPath}), (String)AssetHelper.getDIRECTIVE_FILE_SEPARATOR());
                            relativeFileName = string = AssetHelper.normalizePath(relativeFileName);
                            currFile = assetFile = AssetHelper.fileForUri(relativeFileName, "application/javascript");
                        }
                        if (!DefaultTypeTransformation.booleanUnbox(currFile)) {
                            AssetFile assetFile;
                            currFile = assetFile = AssetHelper.fileForUri(assetPath, "application/javascript");
                        }
                        if (!DefaultTypeTransformation.booleanUnbox(currFile)) {
                            AssetFile assetFile;
                            currFile = assetFile = AssetHelper.fileForUri(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)assetPath, (CharSequence)"/"), (CharSequence)assetPath), "application/javascript");
                        }
                        if (!DefaultTypeTransformation.booleanUnbox((Object)currFile)) {
                            if (!assetPath.startsWith("/") && ((AssetFile)this.assetFile.get()).getParentPath() != null) {
                                AssetFile assetFile;
                                String string;
                                String relativeFileName = DefaultGroovyMethods.join((Iterable)ScriptBytecodeAdapter.createList((Object[])new Object[]{((AssetFile)this.assetFile.get()).getParentPath(), assetPath, "index.js"}), (String)AssetHelper.getDIRECTIVE_FILE_SEPARATOR());
                                relativeFileName = string = AssetHelper.normalizePath(relativeFileName);
                                currFile = assetFile = AssetHelper.fileForUri(relativeFileName, "application/javascript");
                            }
                            if (!DefaultTypeTransformation.booleanUnbox((Object)currFile)) {
                                AssetFile assetFile;
                                currFile = assetFile = AssetHelper.fileForUri(StringGroovyMethods.plus((String)assetPath, (CharSequence)"/index.js"), "application/javascript");
                            }
                            if (!DefaultTypeTransformation.booleanUnbox((Object)currFile)) {
                                AssetFile assetFile;
                                currFile = assetFile = AssetHelper.fileForUri(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)assetPath, (CharSequence)"/"), (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)StringGroovyMethods.tokenize((CharSequence)assetPath, (CharSequence)"/"), (int)-1), CharSequence.class))), (CharSequence)"/index.js"), "application/javascript");
                            }
                        }
                        if (!DefaultTypeTransformation.booleanUnbox((Object)currFile)) {
                            if (!assetPath.startsWith("/")) {
                                AssetFile assetFile;
                                String string;
                                String relativeFileName = DefaultGroovyMethods.join((Iterable)ScriptBytecodeAdapter.createList((Object[])new Object[]{((AssetFile)this.assetFile.get()).getParentPath(), assetPath}), (String)AssetHelper.getDIRECTIVE_FILE_SEPARATOR());
                                relativeFileName = string = AssetHelper.normalizePath(relativeFileName);
                                currFile = assetFile = AssetHelper.fileForUri(relativeFileName);
                            }
                            if (!DefaultTypeTransformation.booleanUnbox((Object)currFile)) {
                                AssetFile assetFile;
                                currFile = assetFile = AssetHelper.fileForUri(assetPath);
                            }
                            if (!DefaultTypeTransformation.booleanUnbox((Object)currFile)) {
                                AssetFile assetFile;
                                currFile = assetFile = AssetHelper.fileForUri(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)assetPath, (CharSequence)"/"), (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)StringGroovyMethods.tokenize((CharSequence)assetPath, (CharSequence)"/"), (int)-1), CharSequence.class))));
                            }
                        }
                        if (!DefaultTypeTransformation.booleanUnbox((Object)currFile)) {
                            String string = (String)ScriptBytecodeAdapter.asType(null, String.class);
                            DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.cachedPaths.get(), Map.class)), (Object)assetPath, (Object)string);
                            return StringGroovyMethods.plus((String)resultPrefix, (CharSequence)new GStringImpl(new Object[]{quote, assetPath, quote}, new String[]{"require(", "", "", ")"}));
                        }
                        if (currFile instanceof GenericAssetFile) {
                            ((JsRequireProcessor)this.getThisObject()).appendUrlModule(currFile, ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethodSafe((Object)((JsRequireProcessor)this.getThisObject()), (String)"replacementAssetPath", (Object)new Object[]{this.assetFile.get(), currFile})));
                            String string = currFile.getPath();
                            DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.cachedPaths.get(), Map.class)), (Object)assetPath, (Object)string);
                            return StringGroovyMethods.plus((String)resultPrefix, (CharSequence)new GStringImpl(new Object[]{quote, currFile.getPath(), quote}, new String[]{"_asset_pipeline_require(", "", "", ")"}));
                        }
                        AssetFile assetFile = ((AssetFile)this.assetFile.get()).getBaseFile();
                        AssetFile assetFile2 = DefaultTypeTransformation.booleanUnbox((Object)assetFile) ? assetFile : (AssetFile)ScriptBytecodeAdapter.castToType((Object)this.assetFile.get(), AssetFile.class);
                        currFile.setBaseFile(assetFile2);
                        ((JsRequireProcessor)this.getThisObject()).appendModule(currFile);
                        String string = currFile.getPath();
                        DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.cachedPaths.get(), Map.class)), (Object)assetPath, (Object)string);
                        return StringGroovyMethods.plus((String)resultPrefix, (CharSequence)new GStringImpl(new Object[]{quote, currFile.getPath(), quote}, new String[]{"_asset_pipeline_require(", "", "", ")"}));
                    }
                    return StringGroovyMethods.plus((String)resultPrefix, (CharSequence)new GStringImpl(new Object[]{quote, assetPath, quote}, new String[]{"require(", "", "", ")"}));
                }

                public Object call(String urlCall, String quote, String assetPath) {
                    return this.doCall(urlCall, quote, assetPath);
                }

                public Map getCachedPaths() {
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.cachedPaths.get(), Map.class);
                }

                public AssetFile getAssetFile() {
                    return (AssetFile)ScriptBytecodeAdapter.castToType((Object)this.assetFile.get(), AssetFile.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _process_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            String result = StringGroovyMethods.replaceAll((CharSequence)inputText, (Pattern)URL_CALL_PATTERN, (Closure)new _process_closure1(this, this, cachedPaths, assetFile2));
            if (ScriptBytecodeAdapter.compareEqual((Object)baseModule.get(), (Object)((AssetFile)assetFile2.get()).getPath()) && DefaultTypeTransformation.booleanUnbox(commonJsModules.get())) {
                String string2;
                result = string2 = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)requireMethod, (CharSequence)this.modulesJs()), (CharSequence)result);
            }
            string = result;
            bl = originator;
        }
        catch (Throwable throwable) {
            Boolean bl3 = originator;
            if (bl3 == null ? false : bl3) {
                commonJsModules.set(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                baseModule.set(null);
            }
            throw throwable;
        }
        if (bl == null ? false : bl) {
            commonJsModules.set(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
            baseModule.set(null);
        }
        return string;
    }

    private Object appendModule(AssetFile assetFile) {
        Map moduleMap = (Map)ScriptBytecodeAdapter.castToType(commonJsModules.get(), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)moduleMap)) {
            Map map;
            moduleMap = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            commonJsModules.set(moduleMap);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)moduleMap, (Object)assetFile.getPath()))) {
            return null;
        }
        String placeHolderModule = "\n\t\t(function() {\n\t\t  var module = {exports: {}};\n\t\t  var exports = module.exports;\n\t\t  return module;\n\t\t})\n\t\t";
        String string = placeHolderModule;
        DefaultGroovyMethods.putAt((Map)moduleMap, (Object)assetFile.getPath(), (Object)string);
        String string2 = this.encapsulateModule(assetFile);
        DefaultGroovyMethods.putAt((Map)moduleMap, (Object)assetFile.getPath(), (Object)string2);
        CacheManager.addCacheDependency(ShortTypeHandling.castToString((Object)baseModule.get()), assetFile);
        return null;
    }

    private Object appendUrlModule(AssetFile assetFile, String url) {
        Map moduleMap = (Map)ScriptBytecodeAdapter.castToType(commonJsModules.get(), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)moduleMap)) {
            Map map;
            moduleMap = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            commonJsModules.set(moduleMap);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)moduleMap, (Object)assetFile.getPath()))) {
            return null;
        }
        String placeHolderModule = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{url}, new String[]{"\n\t\t(function() {\n\t\t  var module = {exports: \"", "\"};\n\t\t  return module;\n\t\t})\n\t\t"}));
        String string = placeHolderModule;
        DefaultGroovyMethods.putAt((Map)moduleMap, (Object)assetFile.getPath(), (Object)string);
        return string;
    }

    private String encapsulateModule(AssetFile assetFile) {
        String encapsulation = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{assetFile.processedStream(this.getPrecompiler(), true)}, new String[]{"\n(function() {\n  var module = {exports: {}};\n  var exports = module.exports;\n\n  ", "\n\n  return module;\n})\n"}));
        return encapsulation;
    }

    private String modulesJs() {
        String string;
        String output = "var _asset_pipeline_modules = _asset_pipeline_modules || {};\n";
        Map<String, String> map = commonJsModules.get();
        public class _modulesJs_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _modulesJs_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object path, Object encapsulation) {
                return new GStringImpl(new Object[]{path, encapsulation}, new String[]{"_asset_pipeline_modules['", "'] = ", ";"});
            }

            public Object call(Object path, Object encapsulation) {
                return this.doCall(path, encapsulation);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _modulesJs_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        output = string = StringGroovyMethods.plus((String)output, (CharSequence)DefaultGroovyMethods.join(map != null ? DefaultGroovyMethods.collect((Map)((Map)ScriptBytecodeAdapter.castToType(map, Map.class)), (Closure)new _modulesJs_closure2(this, this)) : null, (String)"\n"));
        return output;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JsRequireProcessor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static String getRequireMethod() {
        return requireMethod;
    }
}

