/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io3.stores;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class UnzippedPartStore
implements PartStore {
    private static Logger log = LoggerFactory.getLogger(UnzippedPartStore.class);
    private File dir;
    private PartStore sourcePartStore;

    public UnzippedPartStore(File dir) throws Docx4JException {
        this.dir = dir;
    }

    @Override
    public void setSourcePartStore(PartStore partStore) {
        this.sourcePartStore = partStore;
    }

    @Override
    public InputStream loadPart(String partName) throws Docx4JException {
        FileInputStream is;
        String filePath = this.dir.getPath() + File.separator + partName;
        System.out.println("Using " + filePath);
        try {
            is = new FileInputStream(new File(filePath));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return is;
    }

    @Override
    public long getPartSize(String partName) throws Docx4JException {
        String filePath = this.dir.getPath() + File.separator + partName;
        File f = new File(filePath);
        if (f.exists()) {
            return f.length();
        }
        return -1L;
    }

    @Override
    public void rename(PartName oldName, PartName newName) {
        log.info("Renaming part " + oldName.getName() + " to " + newName.getName());
        String filePath = this.dir.getPath() + File.separator + oldName.getName();
        File f = new File(filePath);
        f.renameTo(new File(this.dir.getPath() + File.separator + newName.getName()));
    }

    @Override
    public void setOutputStream(OutputStream os) {
    }

    @Override
    public void saveContentTypes(ContentTypeManager ctm) throws Docx4JException {
        try {
            String filePath = this.dir.getPath() + File.separator + "[Content_Types].xml";
            FileOutputStream fos = new FileOutputStream(new File(filePath));
            ctm.marshal(fos);
            fos.close();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling Content_Types ", e);
        }
    }

    @Override
    public void saveJaxbXmlPart(JaxbXmlPart part) throws Docx4JException {
        String targetName = part.getPartName().getName().equals("_rels/.rels") ? part.getPartName().getName() : part.getPartName().getName().substring(1);
        String filePath = this.dir.getPath() + File.separator + targetName;
        System.out.println("Saving " + filePath);
        try {
            File file = new File(filePath);
            file.getParentFile().mkdirs();
            if (part.isUnmarshalled()) {
                FileOutputStream fos = new FileOutputStream(file);
                log.debug("marshalling " + part.getPartName());
                part.marshal(fos);
                fos.close();
            } else {
                if (!file.exists() && this.sourcePartStore == null) {
                    throw new Docx4JException("part store has changed, and sourcePartStore not set");
                }
                InputStream is = this.sourcePartStore.loadPart(part.getPartName().getName().substring(1));
                FileOutputStream fos = new FileOutputStream(file);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = is.read(bytes)) != -1) {
                    fos.write(bytes, 0, read);
                }
                is.close();
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling JaxbXmlPart " + part.getPartName(), e);
        }
    }

    @Override
    public void saveCustomXmlDataStoragePart(CustomXmlDataStoragePart part) throws Docx4JException {
        String targetName = part.getPartName().getName().substring(1);
        String filePath = this.dir.getPath() + File.separator + targetName;
        File file = new File(filePath);
        file.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(file);
            part.getData().writeDocument(fos);
            fos.close();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling CustomXmlDataStoragePart " + part.getPartName(), e);
        }
    }

    @Override
    public void saveXmlPart(XmlPart part) throws Docx4JException {
        String targetName = part.getPartName().getName().substring(1);
        String filePath = this.dir.getPath() + File.separator + targetName;
        File file = new File(filePath);
        file.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(file);
            Document doc = part.getDocument();
            DOMSource source = new DOMSource(doc);
            XmlUtils.getTransformerFactory().newTransformer().transform(source, new StreamResult(fos));
            fos.close();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling XmlPart " + part.getPartName(), e);
        }
    }

    @Override
    public void saveBinaryPart(Part part) throws Docx4JException {
        String resolvedPartUri = part.getPartName().getName().substring(1);
        String filePath = this.dir.getPath() + File.separator + resolvedPartUri;
        System.out.println("saveBinaryPart " + filePath);
        File file = new File(filePath);
        file.getParentFile().mkdirs();
        try {
            if (((BinaryPart)part).isLoaded()) {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(((BinaryPart)part).getBytes());
                fos.close();
            } else if (!file.exists()) {
                if (this.sourcePartStore == null) {
                    throw new Docx4JException("part store has changed, and sourcePartStore not set");
                }
                InputStream is = this.sourcePartStore.loadPart(part.getPartName().getName().substring(1));
                int read = 0;
                byte[] bytes = new byte[1024];
                FileOutputStream fos = new FileOutputStream(file);
                while ((read = is.read(bytes)) != -1) {
                    fos.write(bytes, 0, read);
                }
                is.close();
            }
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to put binary part", e);
        }
        log.info("success writing part: " + resolvedPartUri);
    }

    @Override
    public void finishSave() throws Docx4JException {
    }

    @Override
    public void dispose() {
    }
}

