/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.ResultSet;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.CmdInformation;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class CmdInformationSingle
implements CmdInformation {
    private long insertId;
    private int updateCount;
    private int autoIncrement;

    public CmdInformationSingle(long insertId, int updateCount, int autoIncrement) {
        this.insertId = insertId;
        this.updateCount = updateCount;
        this.autoIncrement = autoIncrement;
    }

    @Override
    public int[] getUpdateCounts() {
        return new int[]{this.updateCount};
    }

    @Override
    public int getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public void addSuccessStat(int updateCount, long insertId) {
    }

    @Override
    public void addErrorStat() {
    }

    @Override
    public void addResultSetStat() {
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol) {
        if (this.insertId == 0L) {
            return MariaSelectResultSet.createEmptyResultSet();
        }
        if (this.updateCount > 1) {
            long[] insertIds = new long[this.updateCount];
            for (int i = 0; i < this.updateCount; ++i) {
                insertIds[i] = this.insertId + (long)(i * this.autoIncrement);
            }
            return MariaSelectResultSet.createGeneratedData(insertIds, protocol, true);
        }
        return MariaSelectResultSet.createGeneratedData(new long[]{this.insertId}, protocol, true);
    }

    @Override
    public ResultSet getBatchGeneratedKeys(Protocol protocol) {
        return this.getGeneratedKeys(protocol);
    }

    @Override
    public int getCurrentStatNumber() {
        return 1;
    }

    @Override
    public boolean moreResults() {
        this.updateCount = -1;
        return false;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        return this.updateCount != -1;
    }

    @Override
    public int[] getRewriteUpdateCounts() {
        return null;
    }
}

