/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.connections;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.grails.datastore.gorm.jdbc.connections.CachedDataSourceConnectionSourceFactory;
import org.grails.datastore.gorm.jdbc.connections.DataSourceConnectionSourceFactory;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettings;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettingsBuilder;
import org.grails.datastore.mapping.core.connections.AbstractConnectionSourceFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.orm.hibernate.connections.HibernateConnectionSourceSettings;
import org.grails.orm.hibernate.connections.HibernateConnectionSourceSettingsBuilder;
import org.hibernate.SessionFactory;
import org.springframework.core.env.PropertyResolver;

public abstract class AbstractHibernateConnectionSourceFactory
extends AbstractConnectionSourceFactory<SessionFactory, HibernateConnectionSourceSettings> {
    protected DataSourceConnectionSourceFactory dataSourceConnectionSourceFactory = new CachedDataSourceConnectionSourceFactory();

    public void setDataSourceConnectionSourceFactory(DataSourceConnectionSourceFactory dataSourceConnectionSourceFactory) {
        this.dataSourceConnectionSourceFactory = dataSourceConnectionSourceFactory;
    }

    public ConnectionSource<SessionFactory, HibernateConnectionSourceSettings> create(String name, HibernateConnectionSourceSettings settings) {
        DataSourceSettings dataSourceSettings = settings.getDataSource();
        ConnectionSource dataSourceConnectionSource = this.dataSourceConnectionSourceFactory.create(name, dataSourceSettings);
        return this.create(name, (ConnectionSource<DataSource, DataSourceSettings>)dataSourceConnectionSource, settings);
    }

    public Serializable getConnectionSourcesConfigurationKey() {
        return "dataSources";
    }

    public <F extends ConnectionSourceSettings> HibernateConnectionSourceSettings buildRuntimeSettings(String name, PropertyResolver configuration, F fallbackSettings) {
        return this.buildSettingsWithPrefix(configuration, fallbackSettings, "");
    }

    public abstract ConnectionSource<SessionFactory, HibernateConnectionSourceSettings> create(String var1, ConnectionSource<DataSource, DataSourceSettings> var2, HibernateConnectionSourceSettings var3);

    protected <F extends ConnectionSourceSettings> HibernateConnectionSourceSettings buildSettings(String name, PropertyResolver configuration, F fallbackSettings, boolean isDefaultDataSource) {
        HibernateConnectionSourceSettings settings;
        if (isDefaultDataSource) {
            String qualified = "dataSources.dataSource";
            HibernateConnectionSourceSettingsBuilder builder = new HibernateConnectionSourceSettingsBuilder(configuration, "", fallbackSettings);
            Map config = (Map)configuration.getProperty(qualified, Map.class, Collections.emptyMap());
            settings = builder.build();
            if (!config.isEmpty()) {
                DataSourceSettings dsfallbackSettings = null;
                if (fallbackSettings instanceof HibernateConnectionSourceSettings) {
                    dsfallbackSettings = ((HibernateConnectionSourceSettings)fallbackSettings).getDataSource();
                } else if (fallbackSettings instanceof DataSourceSettings) {
                    dsfallbackSettings = (DataSourceSettings)fallbackSettings;
                }
                DataSourceSettingsBuilder dataSourceSettingsBuilder = new DataSourceSettingsBuilder(configuration, qualified, (Object)dsfallbackSettings);
                DataSourceSettings dataSourceSettings = (DataSourceSettings)dataSourceSettingsBuilder.build();
                settings.setDataSource(dataSourceSettings);
            }
        } else {
            String prefix = "dataSources." + name;
            settings = this.buildSettingsWithPrefix(configuration, fallbackSettings, prefix);
        }
        return settings;
    }

    private <F extends ConnectionSourceSettings> HibernateConnectionSourceSettings buildSettingsWithPrefix(PropertyResolver configuration, F fallbackSettings, String prefix) {
        HibernateConnectionSourceSettingsBuilder builder = new HibernateConnectionSourceSettingsBuilder(configuration, prefix, fallbackSettings);
        DataSourceSettings dsfallbackSettings = null;
        if (fallbackSettings instanceof HibernateConnectionSourceSettings) {
            dsfallbackSettings = ((HibernateConnectionSourceSettings)fallbackSettings).getDataSource();
        } else if (fallbackSettings instanceof DataSourceSettings) {
            dsfallbackSettings = (DataSourceSettings)fallbackSettings;
        }
        HibernateConnectionSourceSettings settings = builder.build();
        if (prefix.length() == 0) {
            DataSourceSettingsBuilder dataSourceSettingsBuilder = new DataSourceSettingsBuilder(configuration, prefix, (Object)dsfallbackSettings);
            DataSourceSettings dataSourceSettings = (DataSourceSettings)dataSourceSettingsBuilder.build();
            settings.setDataSource(dataSourceSettings);
        } else if (((Map)configuration.getProperty(prefix + ".dataSource", Map.class, Collections.emptyMap())).isEmpty()) {
            DataSourceSettingsBuilder dataSourceSettingsBuilder = new DataSourceSettingsBuilder(configuration, prefix, (Object)dsfallbackSettings);
            DataSourceSettings dataSourceSettings = (DataSourceSettings)dataSourceSettingsBuilder.build();
            settings.setDataSource(dataSourceSettings);
        }
        return settings;
    }
}

