/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.wrapper;

import com.p6spy.engine.common.ResultSetInformation;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.JdbcEventListener;
import com.p6spy.engine.wrapper.AbstractWrapper;
import com.p6spy.engine.wrapper.ResultSetWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementWrapper
extends AbstractWrapper
implements Statement {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Statement delegate;
    protected final JdbcEventListener eventListener;
    private final StatementInformation statementInformation;

    public static Statement wrap(Statement delegate, StatementInformation statementInformation, JdbcEventListener eventListener) {
        if (delegate == null) {
            return null;
        }
        return new StatementWrapper(delegate, statementInformation, eventListener);
    }

    protected StatementWrapper(Statement delegate, StatementInformation statementInformation, JdbcEventListener eventListener) {
        super(delegate);
        this.delegate = delegate;
        this.eventListener = eventListener;
        this.statementInformation = statementInformation;
        statementInformation.setStatement(delegate);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            ResultSet resultSet = ResultSetWrapper.wrap(this.delegate.getResultSet(), new ResultSetInformation(this.statementInformation), this.eventListener);
            return resultSet;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterGetResultSet(this.statementInformation, System.nanoTime() - start, e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecuteQuery(this.statementInformation, sql);
            ResultSet resultSet = ResultSetWrapper.wrap(this.delegate.executeQuery(sql), new ResultSetInformation(this.statementInformation), this.eventListener);
            return resultSet;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteQuery(this.statementInformation, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int[] updateCounts = null;
        try {
            this.eventListener.onBeforeExecuteBatch(this.statementInformation);
            int[] nArray = updateCounts = this.delegate.executeBatch();
            return nArray;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteBatch(this.statementInformation, System.nanoTime() - start, updateCounts, e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation, sql);
            boolean bl = this.delegate.execute(sql);
            return bl;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation, sql);
            boolean bl = this.delegate.execute(sql, autoGeneratedKeys);
            return bl;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation, sql);
            boolean bl = this.delegate.execute(sql, columnIndexes);
            return bl;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation, sql);
            boolean bl = this.delegate.execute(sql, columnNames);
            return bl;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
            int n = rowCount = this.delegate.executeUpdate(sql);
            return n;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
            int n = rowCount = this.delegate.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
            int n = rowCount = this.delegate.executeUpdate(sql, columnIndexes);
            return n;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
            int n = rowCount = this.delegate.executeUpdate(sql, columnNames);
            return n;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.statementInformation.getStatementQuery() == null) {
            this.statementInformation.setStatementQuery(sql);
        } else {
            this.statementInformation.setStatementQuery(sql + LINE_SEPARATOR + this.statementInformation.getStatementQuery());
        }
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeAddBatch(this.statementInformation, sql);
            this.delegate.addBatch(sql);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterAddBatch(this.statementInformation, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public void close() throws SQLException {
        SQLException e = null;
        try {
            this.delegate.close();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterStatementClose(this.statementInformation, e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.delegate.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.delegate.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.delegate.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.delegate.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.delegate.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.delegate.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.delegate.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.delegate.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.delegate.setCursorName(name);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.delegate.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.delegate.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.delegate.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.delegate.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.delegate.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.delegate.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.delegate.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.delegate.getResultSetType();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.delegate.clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.delegate.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.delegate.getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.delegate.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.delegate.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.delegate.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.delegate.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.delegate.isCloseOnCompletion();
    }
}

