/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.yaml.SpringProfileDocumentMatcher;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlPropertySourceLoader
implements PropertySourceLoader {
    @Override
    public String[] getFileExtensions() {
        return new String[]{"yml", "yaml"};
    }

    @Override
    public PropertySource<?> load(String name, Resource resource, String profile) throws IOException {
        Processor processor;
        Map<String, Object> source;
        if (ClassUtils.isPresent((String)"org.yaml.snakeyaml.Yaml", null) && !(source = (processor = new Processor(resource, profile)).process()).isEmpty()) {
            return new MapPropertySource(name, source);
        }
        return null;
    }

    private static class Processor
    extends YamlProcessor {
        Processor(Resource resource, String profile) {
            if (profile == null) {
                this.setMatchDefault(true);
                this.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{new SpringProfileDocumentMatcher()});
            } else {
                this.setMatchDefault(false);
                this.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{new SpringProfileDocumentMatcher(profile)});
            }
            this.setResources(new Resource[]{resource});
        }

        protected Yaml createYaml() {
            return new Yaml((BaseConstructor)new YamlProcessor.StrictMapAppenderConstructor(), new Representer(), new DumperOptions(), new Resolver(){

                public void addImplicitResolver(Tag tag, Pattern regexp, String first) {
                    if (tag == Tag.TIMESTAMP) {
                        return;
                    }
                    super.addImplicitResolver(tag, regexp, first);
                }
            });
        }

        public Map<String, Object> process() {
            final LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.process(new YamlProcessor.MatchCallback(){

                public void process(Properties properties, Map<String, Object> map) {
                    result.putAll(Processor.this.getFlattenedMap(map));
                }
            });
            return result;
        }
    }
}

