/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.ClassType;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.GroupSequenceType;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;

class ConstrainedTypeBuilder {
    private final ClassLoadingHelper classLoadingHelper;
    private final MetaConstraintBuilder metaConstraintBuilder;
    private final AnnotationProcessingOptionsImpl annotationProcessingOptions;
    private final Map<Class<?>, List<Class<?>>> defaultSequences;

    public ConstrainedTypeBuilder(ClassLoadingHelper classLoadingHelper, MetaConstraintBuilder metaConstraintBuilder, AnnotationProcessingOptionsImpl annotationProcessingOptions, Map<Class<?>, List<Class<?>>> defaultSequences) {
        this.classLoadingHelper = classLoadingHelper;
        this.metaConstraintBuilder = metaConstraintBuilder;
        this.annotationProcessingOptions = annotationProcessingOptions;
        this.defaultSequences = defaultSequences;
    }

    ConstrainedType buildConstrainedType(ClassType classType, Class<?> beanClass, String defaultPackage) {
        if (classType == null) {
            return null;
        }
        List<Class<?>> groupSequence = this.createGroupSequence(classType.getGroupSequence(), defaultPackage);
        if (!groupSequence.isEmpty()) {
            this.defaultSequences.put(beanClass, groupSequence);
        }
        ConstraintLocation constraintLocation = ConstraintLocation.forClass(beanClass);
        HashSet<MetaConstraint<?>> metaConstraints = CollectionHelper.newHashSet();
        for (ConstraintType constraint : classType.getConstraint()) {
            MetaConstraint metaConstraint = this.metaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, ElementType.TYPE, defaultPackage, null);
            metaConstraints.add(metaConstraint);
        }
        if (classType.getIgnoreAnnotations() != null) {
            this.annotationProcessingOptions.ignoreClassLevelConstraintAnnotations(beanClass, classType.getIgnoreAnnotations());
        }
        return new ConstrainedType(ConfigurationSource.XML, constraintLocation, metaConstraints);
    }

    private List<Class<?>> createGroupSequence(GroupSequenceType groupSequenceType, String defaultPackage) {
        ArrayList<Class<?>> groupSequence = CollectionHelper.newArrayList();
        if (groupSequenceType != null) {
            for (String groupName : groupSequenceType.getValue()) {
                Class<?> group = this.classLoadingHelper.loadClass(groupName, defaultPackage);
                groupSequence.add(group);
            }
        }
        return groupSequence;
    }
}

