/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import java.util.Locale;
import org.grails.web.converters.exceptions.ConverterException;
import org.grails.web.converters.marshaller.NameAwareMarshaller;
import org.grails.web.converters.marshaller.ObjectMarshaller;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;

public class ValidationErrorsMarshaller
implements ObjectMarshaller<XML>,
NameAwareMarshaller,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public boolean supports(Object object) {
        return object instanceof Errors;
    }

    @Override
    public void marshalObject(Object object, XML xml) throws ConverterException {
        Errors errors = (Errors)object;
        try {
            for (Object o : errors.getAllErrors()) {
                if (!(o instanceof FieldError)) continue;
                FieldError fe = (FieldError)o;
                xml.startNode("error");
                xml.attribute("object", fe.getObjectName());
                xml.attribute("field", fe.getField());
                xml.startNode("rejected-value").convertAnother(fe.getRejectedValue());
                xml.end();
                Locale locale = LocaleContextHolder.getLocale();
                if (this.applicationContext != null) {
                    xml.startNode("message").chars(this.applicationContext.getMessage((MessageSourceResolvable)fe, locale)).end();
                } else {
                    String defaultMessage = fe.getDefaultMessage();
                    if (defaultMessage != null) {
                        xml.startNode("message").chars(defaultMessage).end();
                    }
                }
                xml.end();
            }
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Bean with class " + object.getClass().getName(), e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public String getElementName(Object o) {
        return "errors";
    }
}

