/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.ArrayList;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.util.StringUtils;

public class DbmsChangeSetFilter
implements ChangeSetFilter {
    private Database database;

    public DbmsChangeSetFilter(Database database) {
        this.database = database;
    }

    @Override
    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        if (this.database == null) {
            return new ChangeSetFilterResult(true, "No database connection, cannot evaluate dbms attribute", this.getClass());
        }
        ArrayList<SqlVisitor> visitorsToRemove = new ArrayList<SqlVisitor>();
        for (SqlVisitor visitor : changeSet.getSqlVisitors()) {
            if (DatabaseList.definitionMatches(visitor.getApplicableDbms(), this.database, true)) continue;
            visitorsToRemove.add(visitor);
        }
        changeSet.getSqlVisitors().removeAll(visitorsToRemove);
        String dbmsList = changeSet.getDbmsSet() == null || changeSet.getDbmsSet().isEmpty() ? "all databases" : "'" + StringUtils.join(changeSet.getDbmsSet(), ", ") + "'";
        if (DatabaseList.definitionMatches(changeSet.getDbmsSet(), this.database, true)) {
            return new ChangeSetFilterResult(true, "Database '" + this.database.getShortName() + "' matches " + dbmsList, this.getClass());
        }
        return new ChangeSetFilterResult(false, "Database '" + this.database.getShortName() + "' does not match " + dbmsList, this.getClass());
    }
}

