/*
 * Decompiled with CFR 0.152.
 */
package grails.gorm.validation;

import grails.gorm.validation.ConstrainedProperty;
import grails.gorm.validation.Constraint;
import grails.gorm.validation.VetoingConstraint;
import grails.gorm.validation.exceptions.ValidationConfigurationException;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import groovy.lang.Range;
import groovy.transform.ToString;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.validation.constraints.BlankConstraint;
import org.grails.datastore.gorm.validation.constraints.InListConstraint;
import org.grails.datastore.gorm.validation.constraints.MatchesConstraint;
import org.grails.datastore.gorm.validation.constraints.MaxConstraint;
import org.grails.datastore.gorm.validation.constraints.MaxSizeConstraint;
import org.grails.datastore.gorm.validation.constraints.MinConstraint;
import org.grails.datastore.gorm.validation.constraints.MinSizeConstraint;
import org.grails.datastore.gorm.validation.constraints.NotEqualConstraint;
import org.grails.datastore.gorm.validation.constraints.NullableConstraint;
import org.grails.datastore.gorm.validation.constraints.RangeConstraint;
import org.grails.datastore.gorm.validation.constraints.ScaleConstraint;
import org.grails.datastore.gorm.validation.constraints.SizeConstraint;
import org.grails.datastore.gorm.validation.constraints.factory.ConstraintFactory;
import org.grails.datastore.gorm.validation.constraints.registry.ConstraintRegistry;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.Errors;

@ToString(includes={"owningClass", "propertyType", "propertyName", "appliedConstraints"})
public class DefaultConstrainedProperty
implements ConstrainedProperty,
GroovyObject {
    private final Class<?> owningClass;
    private final Class<?> propertyType;
    private final String propertyName;
    protected final ConstraintRegistry constraintRegistry;
    protected final Map<String, Constraint> appliedConstraints;
    private boolean display;
    private boolean editable;
    private int order;
    private String format;
    private String widget;
    private boolean password;
    private Map attributes;
    private Map<String, Object> metaConstraints;
    private static final ClassPropertyFetcher PROPERTY_FETCHER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    /*
     * WARNING - void declaration
     */
    public DefaultConstrainedProperty(Class<?> clazz, String string, Class<?> clazz2, ConstraintRegistry constraintRegistry) {
        void constraintRegistry2;
        void propertyType;
        void propertyName;
        void owningClass;
        MetaClass metaClass;
        Map map;
        boolean bl;
        boolean bl2;
        LinkedHashMap<String, Constraint> linkedHashMap = new LinkedHashMap<String, Constraint>();
        this.appliedConstraints = linkedHashMap;
        this.display = bl2 = true;
        this.editable = bl = true;
        this.attributes = map = Collections.EMPTY_MAP;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.metaConstraints = hashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var11_11 = owningClass;
        this.owningClass = var11_11;
        void var12_12 = propertyName;
        this.propertyName = var12_12;
        void var13_13 = propertyType;
        this.propertyType = var13_13;
        void var14_14 = constraintRegistry2;
        this.constraintRegistry = var14_14;
    }

    @Override
    public Collection<Constraint> getAppliedConstraints() {
        return this.appliedConstraints.values();
    }

    @Override
    public Constraint getAppliedConstraint(String name) {
        return (Constraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(name), Constraint.class);
    }

    @Override
    public boolean hasAppliedConstraint(String constraintName) {
        return this.appliedConstraints.containsKey(constraintName);
    }

    @Override
    public Comparable getMax() {
        Comparable maxValue = null;
        MaxConstraint maxConstraint = (MaxConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.MAX_CONSTRAINT), MaxConstraint.class);
        RangeConstraint rangeConstraint = (RangeConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.RANGE_CONSTRAINT), RangeConstraint.class);
        if (maxConstraint != null || rangeConstraint != null) {
            Comparable maxConstraintValue = (Comparable)ScriptBytecodeAdapter.castToType((Object)(maxConstraint == null ? null : maxConstraint.getMaxValue()), Comparable.class);
            Comparable rangeConstraintHighValue = (Comparable)ScriptBytecodeAdapter.castToType((Object)(rangeConstraint == null ? null : rangeConstraint.getRange().getTo()), Comparable.class);
            if (maxConstraintValue != null && rangeConstraintHighValue != null) {
                Comparable comparable;
                maxValue = comparable = maxConstraintValue.compareTo(rangeConstraintHighValue) < 0 ? maxConstraintValue : rangeConstraintHighValue;
            } else if (maxConstraintValue == null && rangeConstraintHighValue != null) {
                Comparable comparable;
                maxValue = comparable = rangeConstraintHighValue;
            } else if (maxConstraintValue != null && rangeConstraintHighValue == null) {
                Comparable comparable;
                maxValue = comparable = maxConstraintValue;
            }
        }
        return maxValue;
    }

    public void setMax(Comparable max) {
        String constraintName = ConstrainedProperty.MAX_CONSTRAINT;
        if (max == null) {
            this.appliedConstraints.remove(constraintName);
            return;
        }
        if (!this.propertyType.equals(max.getClass())) {
            throw (Throwable)new MissingPropertyException(constraintName, this.propertyType);
        }
        Range r = this.getRange();
        if (r != null) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Range constraint already set ignoring constraint [", (CharSequence)constraintName), (CharSequence)"] for value ["), (Object)max), (CharSequence)"]"));
                v0 = null;
            } else {
                v0 = null;
            }
            return;
        }
        this.applyConstraintInternal(constraintName, max);
    }

    @Override
    public Comparable getMin() {
        Comparable minValue = null;
        MinConstraint minConstraint = (MinConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.MIN_CONSTRAINT), MinConstraint.class);
        RangeConstraint rangeConstraint = (RangeConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.RANGE_CONSTRAINT), RangeConstraint.class);
        if (minConstraint != null || rangeConstraint != null) {
            Comparable minConstraintValue = (Comparable)ScriptBytecodeAdapter.castToType((Object)(minConstraint != null ? minConstraint.getMinValue() : null), Comparable.class);
            Comparable rangeConstraintLowValue = (Comparable)ScriptBytecodeAdapter.castToType((Object)(rangeConstraint != null ? rangeConstraint.getRange().getFrom() : null), Comparable.class);
            if (minConstraintValue != null && rangeConstraintLowValue != null) {
                Comparable comparable;
                minValue = comparable = minConstraintValue.compareTo(rangeConstraintLowValue) > 0 ? minConstraintValue : rangeConstraintLowValue;
            } else if (minConstraintValue == null && rangeConstraintLowValue != null) {
                Comparable comparable;
                minValue = comparable = rangeConstraintLowValue;
            } else if (minConstraintValue != null && rangeConstraintLowValue == null) {
                Comparable comparable;
                minValue = comparable = minConstraintValue;
            }
        }
        return minValue;
    }

    public void setMin(Comparable min) {
        if (min == null) {
            this.appliedConstraints.remove(ConstrainedProperty.MIN_CONSTRAINT);
            return;
        }
        if (!this.propertyType.equals(min.getClass())) {
            throw (Throwable)new MissingPropertyException(ConstrainedProperty.MIN_CONSTRAINT, this.propertyType);
        }
        Range r = this.getRange();
        if (r != null) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Range constraint already set ignoring constraint [", (CharSequence)ConstrainedProperty.MIN_CONSTRAINT), (CharSequence)"] for value ["), (Object)min), (CharSequence)"]"));
                v0 = null;
            } else {
                v0 = null;
            }
            return;
        }
        this.applyConstraintInternal(ConstrainedProperty.MIN_CONSTRAINT, min);
    }

    @Override
    public List getInList() {
        InListConstraint c = (InListConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.IN_LIST_CONSTRAINT), InListConstraint.class);
        return (List)ScriptBytecodeAdapter.castToType(c == null ? null : c.getList(), List.class);
    }

    public void setInList(List inList) {
        Constraint c = (Constraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.IN_LIST_CONSTRAINT), Constraint.class);
        if (inList == null) {
            this.appliedConstraints.remove(ConstrainedProperty.IN_LIST_CONSTRAINT);
        } else {
            this.applyConstraintInternal(ConstrainedProperty.IN_LIST_CONSTRAINT, inList);
        }
    }

    @Override
    public Range getRange() {
        RangeConstraint c = (RangeConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.RANGE_CONSTRAINT), RangeConstraint.class);
        return (Range)ScriptBytecodeAdapter.castToType((Object)(c == null ? null : c.getRange()), Range.class);
    }

    public void setRange(Range range) {
        if (this.appliedConstraints.containsKey(ConstrainedProperty.MAX_CONSTRAINT)) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Setting range constraint on property [", (CharSequence)this.propertyName), (CharSequence)"] of class ["), this.owningClass), (CharSequence)"] forced removal of max constraint"));
                v0 = null;
            } else {
                v0 = null;
            }
            this.appliedConstraints.remove(ConstrainedProperty.MAX_CONSTRAINT);
        }
        if (this.appliedConstraints.containsKey(ConstrainedProperty.MIN_CONSTRAINT)) {
            Object v1;
            if (log.isWarnEnabled()) {
                log.warn(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Setting range constraint on property [", (CharSequence)this.propertyName), (CharSequence)"] of class ["), this.owningClass), (CharSequence)"] forced removal of min constraint"));
                v1 = null;
            } else {
                v1 = null;
            }
            this.appliedConstraints.remove(ConstrainedProperty.MIN_CONSTRAINT);
        }
        if (range == null) {
            this.appliedConstraints.remove(ConstrainedProperty.RANGE_CONSTRAINT);
        } else {
            this.applyConstraintInternal(ConstrainedProperty.RANGE_CONSTRAINT, range);
        }
    }

    @Override
    public Integer getScale() {
        ScaleConstraint scaleConstraint = (ScaleConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.SCALE_CONSTRAINT), ScaleConstraint.class);
        return (Integer)ScriptBytecodeAdapter.castToType((Object)(scaleConstraint == null ? null : Integer.valueOf(scaleConstraint.getScale())), Integer.class);
    }

    @Override
    public Range getSize() {
        SizeConstraint c = (SizeConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.SIZE_CONSTRAINT), SizeConstraint.class);
        return (Range)ScriptBytecodeAdapter.castToType((Object)(c == null ? null : c.getRange()), Range.class);
    }

    public void setSize(Range size) {
        Constraint c = (Constraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.SIZE_CONSTRAINT), Constraint.class);
        if (size == null) {
            this.appliedConstraints.remove(ConstrainedProperty.SIZE_CONSTRAINT);
        } else {
            this.applyConstraintInternal(ConstrainedProperty.SIZE_CONSTRAINT, size);
        }
    }

    @Override
    public boolean isBlank() {
        Constraint cons = (Constraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.BLANK_CONSTRAINT), Constraint.class);
        return cons == null || DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)((BlankConstraint)ScriptBytecodeAdapter.castToType((Object)cons, BlankConstraint.class)).getParameter(), Boolean.class)));
    }

    public void setBlank(boolean blank) {
        if (this.isNotValidStringType()) {
            throw (Throwable)new MissingPropertyException("Blank constraint can only be applied to a String property", ConstrainedProperty.BLANK_CONSTRAINT, this.owningClass);
        }
        if (!blank) {
            this.applyConstraintInternal(ConstrainedProperty.BLANK_CONSTRAINT, blank);
        } else {
            this.appliedConstraints.remove(ConstrainedProperty.BLANK_CONSTRAINT);
        }
    }

    @Override
    public boolean isEmail() {
        if (this.isNotValidStringType()) {
            throw (Throwable)new MissingPropertyException("Email constraint only applies to a String property", ConstrainedProperty.EMAIL_CONSTRAINT, this.owningClass);
        }
        return this.appliedConstraints.containsKey(ConstrainedProperty.EMAIL_CONSTRAINT);
    }

    public void setEmail(boolean email) {
        if (this.isNotValidStringType()) {
            throw (Throwable)new MissingPropertyException("Email constraint can only be applied to a String property", ConstrainedProperty.EMAIL_CONSTRAINT, this.owningClass);
        }
        Constraint c = (Constraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.EMAIL_CONSTRAINT), Constraint.class);
        if (email) {
            this.applyConstraintInternal(ConstrainedProperty.EMAIL_CONSTRAINT, email);
        } else if (c != null) {
            this.appliedConstraints.remove(ConstrainedProperty.EMAIL_CONSTRAINT);
        }
    }

    private boolean isNotValidStringType() {
        return !CharSequence.class.isAssignableFrom(this.propertyType);
    }

    @Override
    public boolean isCreditCard() {
        if (this.isNotValidStringType()) {
            throw (Throwable)new MissingPropertyException("CreditCard constraint only applies to a String property", ConstrainedProperty.CREDIT_CARD_CONSTRAINT, this.owningClass);
        }
        return this.appliedConstraints.containsKey(ConstrainedProperty.CREDIT_CARD_CONSTRAINT);
    }

    public void setCreditCard(boolean creditCard) {
        if (this.isNotValidStringType()) {
            throw (Throwable)new MissingPropertyException("CreditCard constraint only applies to a String property", ConstrainedProperty.CREDIT_CARD_CONSTRAINT, this.owningClass);
        }
        Constraint c = (Constraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.CREDIT_CARD_CONSTRAINT), Constraint.class);
        if (creditCard) {
            this.applyConstraintInternal(ConstrainedProperty.CREDIT_CARD_CONSTRAINT, creditCard);
        } else if (c != null) {
            this.appliedConstraints.remove(ConstrainedProperty.CREDIT_CARD_CONSTRAINT);
        }
    }

    @Override
    public String getMatches() {
        if (this.isNotValidStringType()) {
            throw (Throwable)new MissingPropertyException("Matches constraint only applies to a String property", ConstrainedProperty.MATCHES_CONSTRAINT, this.owningClass);
        }
        MatchesConstraint c = (MatchesConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.MATCHES_CONSTRAINT), MatchesConstraint.class);
        return ShortTypeHandling.castToString((Object)(c == null ? null : c.getRegex()));
    }

    public void setMatches(String regex) {
        if (this.isNotValidStringType()) {
            throw (Throwable)new MissingPropertyException("Matches constraint can only be applied to a String property", ConstrainedProperty.MATCHES_CONSTRAINT, this.owningClass);
        }
        if (regex == null) {
            this.appliedConstraints.remove(ConstrainedProperty.MATCHES_CONSTRAINT);
        } else {
            this.applyConstraintInternal(ConstrainedProperty.MATCHES_CONSTRAINT, regex);
        }
    }

    @Override
    public Object getNotEqual() {
        NotEqualConstraint c = (NotEqualConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.NOT_EQUAL_CONSTRAINT), NotEqualConstraint.class);
        return c == null ? null : c.getNotEqualTo();
    }

    @Override
    public Integer getMaxSize() {
        Integer maxSize = null;
        MaxSizeConstraint maxSizeConstraint = (MaxSizeConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.MAX_SIZE_CONSTRAINT), MaxSizeConstraint.class);
        SizeConstraint sizeConstraint = (SizeConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.SIZE_CONSTRAINT), SizeConstraint.class);
        if (maxSizeConstraint != null || sizeConstraint != null) {
            int maxSizeConstraintValue = maxSizeConstraint == null ? Integer.MAX_VALUE : maxSizeConstraint.getMaxSize();
            int sizeConstraintHighValue = sizeConstraint == null ? Integer.MAX_VALUE : sizeConstraint.getRange().getToInt();
            int n = Math.min(maxSizeConstraintValue, sizeConstraintHighValue);
            maxSize = n;
        }
        return maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.applyConstraintInternal(ConstrainedProperty.MAX_SIZE_CONSTRAINT, maxSize);
    }

    @Override
    public Integer getMinSize() {
        Integer minSize = null;
        MinSizeConstraint minSizeConstraint = (MinSizeConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.MIN_SIZE_CONSTRAINT), MinSizeConstraint.class);
        SizeConstraint sizeConstraint = (SizeConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.SIZE_CONSTRAINT), SizeConstraint.class);
        if (minSizeConstraint != null || sizeConstraint != null) {
            int minSizeConstraintValue = minSizeConstraint == null ? Integer.MIN_VALUE : minSizeConstraint.getMinSize();
            int sizeConstraintLowValue = sizeConstraint == null ? Integer.MIN_VALUE : sizeConstraint.getRange().getFromInt();
            int n = Math.max(minSizeConstraintValue, sizeConstraintLowValue);
            minSize = n;
        }
        return minSize;
    }

    public void setMinSize(Integer minSize) {
        this.applyConstraintInternal(ConstrainedProperty.MIN_SIZE_CONSTRAINT, minSize);
    }

    public void setNotEqual(Object notEqual) {
        if (notEqual == null) {
            this.appliedConstraints.remove(ConstrainedProperty.NOT_EQUAL_CONSTRAINT);
        } else {
            this.applyConstraintInternal(ConstrainedProperty.NOT_EQUAL_CONSTRAINT, notEqual);
        }
    }

    @Override
    public boolean isNullable() {
        if (this.appliedConstraints.containsKey(ConstrainedProperty.NULLABLE_CONSTRAINT)) {
            NullableConstraint nc = (NullableConstraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.NULLABLE_CONSTRAINT), NullableConstraint.class);
            return nc.isNullable();
        }
        return false;
    }

    public void setNullable(boolean nullable) {
        this.applyConstraintInternal(ConstrainedProperty.NULLABLE_CONSTRAINT, nullable);
    }

    @Override
    public boolean isUrl() {
        if (this.isNotValidStringType()) {
            throw (Throwable)new MissingPropertyException("URL constraint can only be applied to a String property", ConstrainedProperty.URL_CONSTRAINT, this.owningClass);
        }
        return this.appliedConstraints.containsKey(ConstrainedProperty.URL_CONSTRAINT);
    }

    public void setUrl(boolean url) {
        if (this.isNotValidStringType()) {
            throw (Throwable)new MissingPropertyException("URL constraint can only be applied to a String property", ConstrainedProperty.URL_CONSTRAINT, this.owningClass);
        }
        Constraint c = (Constraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(ConstrainedProperty.URL_CONSTRAINT), Constraint.class);
        if (url) {
            this.applyConstraintInternal(ConstrainedProperty.URL_CONSTRAINT, url);
        } else if (c != null) {
            this.appliedConstraints.remove(ConstrainedProperty.URL_CONSTRAINT);
        }
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map attributes) {
        Map map;
        this.attributes = map = attributes;
    }

    @Override
    public void validate(Object target, Object propertyValue, Errors errors) {
        ArrayList<Constraint> delayedConstraints = new ArrayList<Constraint>();
        Constraint c = null;
        Iterator<Constraint> iterator = this.appliedConstraints.values().iterator();
        while (iterator.hasNext()) {
            c = (Constraint)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Constraint.class);
            if (c instanceof VetoingConstraint) {
                if (!((VetoingConstraint)ScriptBytecodeAdapter.castToType((Object)c, VetoingConstraint.class)).validateWithVetoing(target, propertyValue, errors)) continue;
                return;
            }
            delayedConstraints.add(c);
        }
        Constraint c2 = null;
        Iterator iterator2 = delayedConstraints.iterator();
        while (iterator2.hasNext()) {
            c2 = (Constraint)ScriptBytecodeAdapter.castToType(iterator2.next(), Constraint.class);
            c2.validate(target, propertyValue, errors);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean supportsContraint(String constraintName) {
        List<ConstraintFactory> constraintFactories = this.constraintRegistry.findConstraintFactories(constraintName);
        if (constraintFactories.isEmpty()) {
            PropertyDescriptor propertyDescriptor = PROPERTY_FETCHER.getPropertyDescriptor(constraintName);
            if (propertyDescriptor == null) return false;
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) return false;
            return true;
        }
        try {
            ConstraintFactory cf = null;
            Iterator<ConstraintFactory> iterator = constraintFactories.iterator();
            do {
                if (!iterator.hasNext()) return DefaultTypeTransformation.booleanUnbox(null);
            } while (!(cf = (ConstraintFactory)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ConstraintFactory.class)).supports(this.propertyType));
            return true;
        }
        catch (Exception e) {
            Object v1;
            if (log.isErrorEnabled()) {
                log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{constraintName, this.owningClass}, new String[]{"Exception thrown instantiating constraint [", "] to class [", "]"})), (Throwable)e);
                v1 = null;
                throw (Throwable)new ValidationConfigurationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{constraintName, this.owningClass, e.getMessage()}, new String[]{"Exception thrown instantiating constraint [", "] to class [", "]: ", ""})), e);
            } else {
                v1 = null;
            }
            throw (Throwable)new ValidationConfigurationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{constraintName, this.owningClass, e.getMessage()}, new String[]{"Exception thrown instantiating constraint [", "] to class [", "]: ", ""})), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyConstraint(String constraintName, Object constrainingValue) {
        List<ConstraintFactory> constraintFactories = this.constraintRegistry.findConstraintFactories(constraintName);
        if (!constraintFactories.isEmpty()) {
            if (constrainingValue == null) {
                this.appliedConstraints.remove(constraintName);
                return;
            }
            try {
                Constraint c = this.instantiateConstraint(constraintName, constrainingValue, true);
                if (c == null) return;
                boolean bl = true;
                if (!bl) return;
                this.appliedConstraints.put(constraintName, c);
                return;
            }
            catch (Exception e) {
                throw (Throwable)new ValidationConfigurationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{constraintName, this.owningClass, constrainingValue, e.getMessage()}, new String[]{"Exception thrown applying constraint [", "] to class [", "] for value [", "]: ", ""})), e);
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.hasProperty((Object)this, (String)constraintName))) throw (Throwable)new ValidationConfigurationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{constraintName, this.propertyName, this.owningClass, this.propertyType}, new String[]{"Constraint [", "] is not supported for property [", "] of class [", "] with type [", "]"})));
        ((GroovyObject)this).setProperty(constraintName, constrainingValue);
    }

    protected void applyConstraintInternal(String constraintName, Object constrainingValue) {
        Constraint c = (Constraint)ScriptBytecodeAdapter.castToType((Object)this.appliedConstraints.get(constraintName), Constraint.class);
        if (c == null) {
            ConstraintFactory factory = null;
            Iterator<ConstraintFactory> iterator = this.constraintRegistry.findConstraintFactories(constraintName).iterator();
            while (iterator.hasNext()) {
                factory = (ConstraintFactory)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ConstraintFactory.class);
                Object t = factory.build(this.owningClass, this.propertyName, constrainingValue);
                c = t;
                if (!(c != null && c.supports(this.propertyType))) continue;
                this.appliedConstraints.put(constraintName, c);
                break;
            }
        }
    }

    @Override
    public Class getOwner() {
        return this.owningClass;
    }

    private Constraint instantiateConstraint(String constraintName, Object constraintValue, boolean validate) throws InstantiationException, IllegalAccessException {
        List<ConstraintFactory> candidateConstraints = this.constraintRegistry.findConstraintFactories(constraintName);
        ConstraintFactory constraintFactory = null;
        Iterator<ConstraintFactory> iterator = candidateConstraints.iterator();
        while (iterator.hasNext()) {
            constraintFactory = (ConstraintFactory)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ConstraintFactory.class);
            Object c = constraintFactory.build(this.owningClass, this.propertyName, constraintValue);
            if (validate && c.isValid()) {
                return c;
            }
            if (!(!validate)) continue;
            return c;
        }
        return (Constraint)ScriptBytecodeAdapter.castToType(null, Constraint.class);
    }

    public void addMetaConstraint(String name, Object value) {
        this.metaConstraints.put(name, value);
    }

    public Object getMetaConstraintValue(String name) {
        return this.metaConstraints.get(name);
    }

    public Map<String, Object> getMetaConstraints() {
        return this.metaConstraints;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultConstrainedProperty.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("grails.gorm.validation.DefaultConstrainedProperty(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        if (this.getOwningClass() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString(this.getOwningClass()));
        }
        Boolean bl3 = $toStringFirst;
        if (bl3 == null ? false : bl3) {
            Boolean bl4;
            $toStringFirst = bl4 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        if (this.getPropertyType() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString(this.getPropertyType()));
        }
        Boolean bl5 = $toStringFirst;
        if (bl5 == null ? false : bl5) {
            Boolean bl6;
            $toStringFirst = bl6 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        if (this.getPropertyName() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getPropertyName()));
        }
        _result.append(")");
        return _result.toString();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        ClassPropertyFetcher classPropertyFetcher;
        PROPERTY_FETCHER = classPropertyFetcher = ClassPropertyFetcher.forClass(DefaultConstrainedProperty.class);
        log = logger = LoggerFactory.getLogger((String)"grails.gorm.validation.DefaultConstrainedProperty");
    }

    public final Class<?> getOwningClass() {
        return this.owningClass;
    }

    @Override
    public final Class<?> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public final String getPropertyName() {
        return this.propertyName;
    }

    public boolean getDisplay() {
        return this.display;
    }

    @Override
    public boolean isDisplay() {
        return this.display;
    }

    public void setDisplay(boolean bl) {
        this.display = bl;
    }

    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    @Override
    public String getWidget() {
        return this.widget;
    }

    public void setWidget(String string) {
        this.widget = string;
    }

    public boolean getPassword() {
        return this.password;
    }

    @Override
    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean bl) {
        this.password = bl;
    }
}

