/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage.migration;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.utils.SingleTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.Body;
import org.docx4j.wml.Document;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablePrepare {
    private static Logger log = LoggerFactory.getLogger(VariablePrepare.class);
    public static final int FLAG_NONE = 0;
    public static final int FLAG_REMOVE_PROOF_ERRORS = 1;
    public static final int FLAG_REMOVE_CONTENT_CONTROLS = 2;
    public static final int FLAG_REMOVE_RSIDS = 4;
    public static final int FLAG_REMOVE_BOOKMARKS = 8;
    private static final QName _RT_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "t");

    public static void prepare(WordprocessingMLPackage wmlPackage) throws Exception {
        VariablePrepare.prepare(wmlPackage, 0);
    }

    public static void prepare(WordprocessingMLPackage wmlPackage, int flags) throws Exception {
        WordprocessingMLPackage.FilterSettings filterSettings = new WordprocessingMLPackage.FilterSettings();
        if (flags == 0) {
            flags = 15;
        }
        if ((flags & 1) == 1) {
            filterSettings.setRemoveProofErrors(true);
        }
        if ((flags & 2) == 2) {
            filterSettings.setRemoveContentControls(true);
        }
        if ((flags & 4) == 4) {
            filterSettings.setRemoveRsids(true);
        }
        if ((flags & 8) == 8) {
            filterSettings.setRemoveBookmarks(true);
        }
        wmlPackage.filter(filterSettings);
        if (log.isInfoEnabled()) {
            log.info(XmlUtils.marshaltoString(wmlPackage.getMainDocumentPart().getJaxbElement(), true, true));
        }
        Document wmlDocumentEl = (Document)wmlPackage.getMainDocumentPart().getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        SingleTraversalUtilVisitorCallback paragraphVisitor = new SingleTraversalUtilVisitorCallback(new TraversalUtilParagraphVisitor());
        paragraphVisitor.walkJAXBElements(body);
        if (log.isInfoEnabled()) {
            log.info(XmlUtils.marshaltoString(wmlPackage.getMainDocumentPart().getJaxbElement(), true, true));
        }
    }

    public static void joinupRuns(P p) {
        List existingContents = p.getContent();
        ArrayList<Object> newContents = new ArrayList<Object>();
        R currentR = null;
        String currentRPrString = null;
        for (Object e : existingContents) {
            if (e instanceof R) {
                if (currentR == null) {
                    currentR = (R)e;
                    if (currentR.getRPr() != null) {
                        currentRPrString = XmlUtils.marshaltoString((Object)currentR.getRPr(), true);
                    }
                    newContents.add(currentR);
                    continue;
                }
                RPr other = ((R)e).getRPr();
                boolean makeNewRun = true;
                if (currentRPrString == null && other == null) {
                    makeNewRun = false;
                }
                if (currentRPrString != null && other != null && XmlUtils.marshaltoString((Object)other, true).equals(currentRPrString)) {
                    makeNewRun = false;
                }
                if (makeNewRun) {
                    currentR = (R)e;
                    currentRPrString = currentR.getRPr() == null ? null : XmlUtils.marshaltoString((Object)currentR.getRPr(), true);
                    newContents.add(currentR);
                    continue;
                }
                currentR.getContent().addAll(((R)e).getContent());
                continue;
            }
            newContents.add(e);
            currentR = null;
            currentRPrString = null;
        }
        for (Object e : newContents) {
            if (!(e instanceof R)) continue;
            ArrayList<Object> newRunContents = new ArrayList<Object>();
            JAXBElement currentT = null;
            for (Object rc : ((R)e).getContent()) {
                if (rc instanceof JAXBElement && ((JAXBElement)rc).getName().equals(_RT_QNAME)) {
                    if (currentT == null) {
                        currentT = (JAXBElement)rc;
                        newRunContents.add(currentT);
                    } else {
                        Text currentText = (Text)XmlUtils.unwrap(currentT);
                        String val = currentText.getValue();
                        currentText.setValue(val + ((Text)XmlUtils.unwrap(rc)).getValue());
                    }
                    if (((Text)XmlUtils.unwrap(rc)).getSpace() == null || !((Text)XmlUtils.unwrap(rc)).getSpace().equals("preserve")) continue;
                    ((Text)XmlUtils.unwrap(currentT)).setSpace("preserve");
                    continue;
                }
                log.debug(rc.getClass().getName());
                newRunContents.add(rc);
                currentT = null;
            }
            ((R)e).getContent().clear();
            ((R)e).getContent().addAll(newRunContents);
        }
        p.getContent().clear();
        p.getContent().addAll(newContents);
    }

    public static class TraversalUtilParagraphVisitor
    extends TraversalUtilVisitor<P> {
        @Override
        public void apply(P p, Object parent, List<Object> siblings) {
            VariablePrepare.joinupRuns(p);
        }
    }
}

