/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.lang.reflect.Constructor;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;

public class ContextDataFactory {
    private static final String CLASS_NAME = PropertiesUtil.getProperties().getStringProperty("log4j2.ContextData");
    private static final Class<?> CACHED_CLASS = ContextDataFactory.createCachedClass(CLASS_NAME);
    private static final Constructor<?> CACHED_CONSTRUCTOR = ContextDataFactory.createCachedConstructor(CACHED_CLASS);

    private static Class<?> createCachedClass(String className) {
        if (className == null) {
            return null;
        }
        try {
            return LoaderUtil.loadClass((String)className);
        }
        catch (Exception any) {
            return null;
        }
    }

    private static Constructor<?> createCachedConstructor(Class<?> cachedClass) {
        if (cachedClass == null) {
            return null;
        }
        try {
            return cachedClass.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Exception any) {
            return null;
        }
    }

    public static StringMap createContextData() {
        if (CACHED_CLASS == null) {
            return new SortedArrayStringMap();
        }
        try {
            return (StringMap)CACHED_CLASS.newInstance();
        }
        catch (Exception any) {
            return new SortedArrayStringMap();
        }
    }

    public static StringMap createContextData(int initialCapacity) {
        if (CACHED_CONSTRUCTOR == null) {
            return new SortedArrayStringMap(initialCapacity);
        }
        try {
            return (StringMap)CACHED_CONSTRUCTOR.newInstance(initialCapacity);
        }
        catch (Exception any) {
            return new SortedArrayStringMap(initialCapacity);
        }
    }
}

