/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.orm.hibernate.support.HibernateVersionSupport;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.service.spi.ServiceBinding;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.orm.hibernate5.SpringFlushSynchronization;
import org.springframework.orm.hibernate5.SpringJtaSessionContext;
import org.springframework.orm.hibernate5.SpringSessionSynchronization;
import org.springframework.transaction.jta.SpringJtaSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class GrailsSessionContext
implements CurrentSessionContext {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(GrailsSessionContext.class);
    protected final SessionFactoryImplementor sessionFactory;
    protected CurrentSessionContext jtaSessionContext;
    protected boolean allowCreate = false;

    public GrailsSessionContext(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void initJta() {
        JtaPlatform jtaPlatform = (JtaPlatform)this.sessionFactory.getServiceRegistry().getService(JtaPlatform.class);
        TransactionManager transactionManager = jtaPlatform.retrieveTransactionManager();
        this.jtaSessionContext = transactionManager == null ? null : new SpringJtaSessionContext(this.sessionFactory);
    }

    public Session currentSession() throws HibernateException {
        Object value = TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        if (value instanceof Session) {
            return (Session)value;
        }
        if (value instanceof SessionHolder) {
            SessionHolder sessionHolder = (SessionHolder)value;
            Session session = sessionHolder.getSession();
            if (TransactionSynchronizationManager.isSynchronizationActive() && !sessionHolder.isSynchronizedWithTransaction()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this.createSpringSessionSynchronization(sessionHolder));
                sessionHolder.setSynchronizedWithTransaction(true);
                FlushMode flushMode = HibernateVersionSupport.getFlushMode((Session)session);
                if (flushMode.equals((Object)FlushMode.MANUAL) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                    HibernateVersionSupport.setFlushMode((Session)session, (FlushMode)FlushMode.AUTO);
                    sessionHolder.setPreviousFlushMode(flushMode);
                }
            }
            return session;
        }
        if (this.jtaSessionContext != null) {
            Session session = this.jtaSessionContext.currentSession();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this.createSpringFlushSynchronization(session));
            }
            return session;
        }
        if (this.allowCreate) {
            return this.createSession(value);
        }
        throw new HibernateException("No Session found for current thread");
    }

    private Session createSession(Object resource) {
        LOG.debug((Object)"Opening Hibernate Session");
        SessionHolder sessionHolder = (SessionHolder)resource;
        Session session = this.sessionFactory.openSession();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            LOG.debug((Object)"Registering Spring transaction synchronization for new Hibernate Session");
            SessionHolder holderToUse = sessionHolder;
            if (holderToUse == null) {
                holderToUse = new SessionHolder(session);
            }
            if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                session.setFlushMode(FlushMode.MANUAL);
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this.createSpringSessionSynchronization(holderToUse));
            holderToUse.setSynchronizedWithTransaction(true);
            if (holderToUse != sessionHolder) {
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)holderToUse);
            }
        } else {
            this.registerJtaSynchronization(session, sessionHolder);
        }
        return session;
    }

    protected void registerJtaSynchronization(Session session, SessionHolder sessionHolder) {
        TransactionManager jtaTm = this.getJtaTransactionManager(session);
        if (jtaTm == null) {
            return;
        }
        try {
            Transaction jtaTx = jtaTm.getTransaction();
            if (jtaTx == null) {
                return;
            }
            int jtaStatus = jtaTx.getStatus();
            if (jtaStatus != 0 && jtaStatus != 1) {
                return;
            }
            LOG.debug((Object)"Registering JTA transaction synchronization for new Hibernate Session");
            SessionHolder holderToUse = sessionHolder;
            if (holderToUse == null) {
                holderToUse = new SessionHolder(session);
            }
            jtaTx.registerSynchronization((Synchronization)new SpringJtaSynchronizationAdapter(this.createSpringSessionSynchronization(holderToUse), jtaTm));
            holderToUse.setSynchronizedWithTransaction(true);
            if (holderToUse != sessionHolder) {
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)holderToUse);
            }
        }
        catch (Throwable ex) {
            throw new DataAccessResourceFailureException("Could not register synchronization with JTA TransactionManager", ex);
        }
    }

    protected TransactionManager getJtaTransactionManager(Session session) {
        SessionFactory internalFactory;
        SessionFactoryImplementor sessionFactoryImpl = null;
        if (this.sessionFactory instanceof SessionFactoryImplementor) {
            sessionFactoryImpl = this.sessionFactory;
        } else if (session != null && (internalFactory = session.getSessionFactory()) instanceof SessionFactoryImplementor) {
            sessionFactoryImpl = (SessionFactoryImplementor)internalFactory;
        }
        if (sessionFactoryImpl == null) {
            return null;
        }
        ServiceBinding sb = this.sessionFactory.getServiceRegistry().locateServiceBinding(JtaPlatform.class);
        if (sb == null) {
            return null;
        }
        return ((JtaPlatform)sb.getService()).retrieveTransactionManager();
    }

    protected TransactionSynchronization createSpringFlushSynchronization(Session session) {
        return new SpringFlushSynchronization(session);
    }

    protected TransactionSynchronization createSpringSessionSynchronization(SessionHolder sessionHolder) {
        return new SpringSessionSynchronization(sessionHolder, (SessionFactory)this.sessionFactory);
    }
}

