/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.validation.ConstraintValidator;
import org.hibernate.validator.cfg.context.ConstraintDefinitionContext;
import org.hibernate.validator.internal.cfg.context.ConstraintContextImplBase;
import org.hibernate.validator.internal.cfg.context.DefaultConstraintMapping;
import org.hibernate.validator.internal.engine.constraintdefinition.ConstraintDefinitionContribution;
import org.hibernate.validator.internal.util.CollectionHelper;

class ConstraintDefinitionContextImpl<A extends Annotation>
extends ConstraintContextImplBase
implements ConstraintDefinitionContext<A> {
    private final Class<A> annotationType;
    private boolean includeExistingValidators = true;
    private final Set<Class<? extends ConstraintValidator<A, ?>>> validatorTypes = CollectionHelper.newHashSet();

    ConstraintDefinitionContextImpl(DefaultConstraintMapping mapping, Class<A> annotationType) {
        super(mapping);
        this.annotationType = annotationType;
    }

    @Override
    public ConstraintDefinitionContext<A> includeExistingValidators(boolean includeExistingValidators) {
        this.includeExistingValidators = includeExistingValidators;
        return this;
    }

    @Override
    public ConstraintDefinitionContext<A> validatedBy(Class<? extends ConstraintValidator<A, ?>> validator) {
        this.validatorTypes.add(validator);
        return this;
    }

    ConstraintDefinitionContribution<A> build() {
        return new ConstraintDefinitionContribution<A>(this.annotationType, CollectionHelper.newArrayList(this.validatorTypes), this.includeExistingValidators);
    }
}

