/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.boot.actuate.endpoint.jmx.DataConverter;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpoint;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

public abstract class AbstractJmxEndpoint
implements JmxEndpoint,
EnvironmentAware {
    private final DataConverter dataConverter;
    private Environment environment;
    private Boolean enabled;

    public AbstractJmxEndpoint(ObjectMapper objectMapper) {
        this.dataConverter = new DataConverter(objectMapper);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected final Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public boolean isEnabled() {
        return EndpointProperties.isEnabled(this.environment, this.enabled);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getIdentity() {
        return ObjectUtils.getIdentityHexString((Object)this);
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return null;
    }

    protected Object convert(Object data) {
        return this.dataConverter.convert(data);
    }
}

