/*
 * Decompiled with CFR 0.152.
 */
package fr.w3blog.zpl.utils;

import fr.w3blog.zpl.model.ZebraLabel;
import fr.w3blog.zpl.model.ZebraPrintException;
import fr.w3blog.zpl.model.ZebraPrintNotFoundException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.standard.PrinterName;

public class ZebraUtils {
    private static final int DEFAULT_TIMEOUT = 0;

    public static void printZpl(String zpl, String ip, int port, int timeout) throws ZebraPrintException {
        try (Socket clientSocket = new Socket();){
            InetSocketAddress address = new InetSocketAddress(ip, port);
            clientSocket.connect(address, timeout);
            clientSocket.setSoTimeout(timeout);
            DataOutputStream outToServer = new DataOutputStream(clientSocket.getOutputStream());
            outToServer.writeUTF(zpl);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new ZebraPrintException("Cannot print label on this printer : " + ip + ":" + port + " due to timeout", socketTimeoutException);
        }
        catch (IOException e1) {
            throw new ZebraPrintException("Cannot print label on this printer : " + ip + ":" + port, e1);
        }
    }

    public static void printZpl(String zpl, String ip, int port) throws ZebraPrintException {
        ZebraUtils.printZpl(zpl, ip, port, 0);
    }

    public static void printZpl(String zpl, String printerName) throws ZebraPrintException {
        try {
            PrintService psZebra = null;
            String sPrinterName = null;
            PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i = 0; i < services.length; ++i) {
                PrinterName attr = services[i].getAttribute(PrinterName.class);
                sPrinterName = attr.getValue();
                if (sPrinterName.toLowerCase().indexOf(printerName.toLowerCase()) < 0) continue;
                psZebra = services[i];
                break;
            }
            if (psZebra == null) {
                throw new ZebraPrintNotFoundException("Zebra printer not found : " + printerName);
            }
            DocPrintJob job = psZebra.createPrintJob();
            byte[] by = zpl.getBytes();
            DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            SimpleDoc doc = new SimpleDoc(by, flavor, null);
            job.print(doc, null);
        }
        catch (PrintException e) {
            throw new ZebraPrintException("Cannot print label on this printer : " + printerName, e);
        }
    }

    public static void printZpl(ZebraLabel zebraLabel, String ip, int port) throws ZebraPrintException {
        ZebraUtils.printZpl(zebraLabel.getZplCode(), ip, port);
    }

    public static void printZpl(ZebraLabel zebraLabel, String ip, int port, int timeOut) throws ZebraPrintException {
        ZebraUtils.printZpl(zebraLabel.getZplCode(), ip, port, timeOut);
    }

    public static void printZpl(ZebraLabel zebraLabel, String printerName) throws ZebraPrintException {
        ZebraUtils.printZpl(zebraLabel.getZplCode(), printerName);
    }

    public static void printZpl(List<ZebraLabel> zebraLabels, String ip, int port) throws ZebraPrintException {
        StringBuilder zpl = new StringBuilder();
        for (ZebraLabel zebraLabel : zebraLabels) {
            zpl.append(zebraLabel.getZplCode());
        }
        ZebraUtils.printZpl(zpl.toString(), ip, port);
    }

    public static void printZpl(List<ZebraLabel> zebraLabels, String printerName) throws ZebraPrintException {
        StringBuilder zpl = new StringBuilder();
        for (ZebraLabel zebraLabel : zebraLabels) {
            zpl.append(zebraLabel.getZplCode());
        }
        ZebraUtils.printZpl(zpl.toString(), printerName);
    }
}

