/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.AbstractAccessLogValve;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.tomcat.util.json.JSONFilter;

public class JsonAccessLogValve
extends AccessLogValve {
    private static final Map<Character, String> PATTERNS;

    @Override
    protected AbstractAccessLogValve.AccessLogElement[] createLogElements() {
        ArrayList<AbstractAccessLogValve.AccessLogElement> logElements = new ArrayList<AbstractAccessLogValve.AccessLogElement>(Arrays.asList(super.createLogElements()));
        ListIterator<AbstractAccessLogValve.AccessLogElement> lit = logElements.listIterator();
        lit.add(new AbstractAccessLogValve.AccessLogElement(){

            @Override
            public void addElement(CharArrayWriter buf, Date date, Request request, Response response, long time) {
                buf.write(123);
            }
        });
        while (lit.hasNext()) {
            AbstractAccessLogValve.AccessLogElement logElement = (AbstractAccessLogValve.AccessLogElement)lit.next();
            if (!(logElement instanceof JsonWrappedElement)) {
                lit.remove();
                continue;
            }
            lit.add(new AbstractAccessLogValve.AccessLogElement(){

                @Override
                public void addElement(CharArrayWriter buf, Date date, Request request, Response response, long time) {
                    buf.write(44);
                }
            });
        }
        lit.previous();
        lit.remove();
        lit.add(new AbstractAccessLogValve.AccessLogElement(){

            @Override
            public void addElement(CharArrayWriter buf, Date date, Request request, Response response, long time) {
                buf.write(125);
            }
        });
        return logElements.toArray(new AbstractAccessLogValve.AccessLogElement[logElements.size()]);
    }

    @Override
    protected AbstractAccessLogValve.AccessLogElement createAccessLogElement(char pattern) {
        AbstractAccessLogValve.AccessLogElement ale = super.createAccessLogElement(pattern);
        String attributeName = PATTERNS.get(Character.valueOf(pattern));
        if (attributeName == null) {
            attributeName = "other-" + new String(JSONFilter.escape(pattern));
        }
        return new JsonWrappedElement(attributeName, true, ale);
    }

    static {
        HashMap<Character, String> pattern2AttributeName = new HashMap<Character, String>();
        pattern2AttributeName.put(Character.valueOf('a'), "remoteAddr");
        pattern2AttributeName.put(Character.valueOf('A'), "localAddr");
        pattern2AttributeName.put(Character.valueOf('b'), "size");
        pattern2AttributeName.put(Character.valueOf('B'), "byteSentNC");
        pattern2AttributeName.put(Character.valueOf('D'), "elapsedTime");
        pattern2AttributeName.put(Character.valueOf('F'), "firstByteTime");
        pattern2AttributeName.put(Character.valueOf('h'), "host");
        pattern2AttributeName.put(Character.valueOf('H'), "protocol");
        pattern2AttributeName.put(Character.valueOf('l'), "logicalUserName");
        pattern2AttributeName.put(Character.valueOf('m'), "method");
        pattern2AttributeName.put(Character.valueOf('p'), "port");
        pattern2AttributeName.put(Character.valueOf('q'), "query");
        pattern2AttributeName.put(Character.valueOf('r'), "request");
        pattern2AttributeName.put(Character.valueOf('s'), "statusCode");
        pattern2AttributeName.put(Character.valueOf('S'), "sessionId");
        pattern2AttributeName.put(Character.valueOf('t'), "time");
        pattern2AttributeName.put(Character.valueOf('T'), "elapsedTimeS");
        pattern2AttributeName.put(Character.valueOf('u'), "user");
        pattern2AttributeName.put(Character.valueOf('U'), "path");
        pattern2AttributeName.put(Character.valueOf('v'), "localServerName");
        pattern2AttributeName.put(Character.valueOf('I'), "threadName");
        pattern2AttributeName.put(Character.valueOf('X'), "connectionStatus");
        PATTERNS = Collections.unmodifiableMap(pattern2AttributeName);
    }

    private static class JsonWrappedElement
    implements AbstractAccessLogValve.AccessLogElement,
    AbstractAccessLogValve.CachedElement {
        private CharSequence attributeName;
        private boolean quoteValue;
        private AbstractAccessLogValve.AccessLogElement delegate;

        private CharSequence escapeJsonString(CharSequence nonEscaped) {
            return JSONFilter.escape(nonEscaped);
        }

        JsonWrappedElement(String attributeName, boolean quoteValue, AbstractAccessLogValve.AccessLogElement delegate) {
            this.attributeName = this.escapeJsonString(attributeName);
            this.quoteValue = quoteValue;
            this.delegate = delegate;
        }

        @Override
        public void addElement(CharArrayWriter buf, Date date, Request request, Response response, long time) {
            buf.append('\"').append(this.attributeName).append('\"').append(':');
            if (this.quoteValue) {
                buf.append('\"');
            }
            JsonCharArrayWriter valueWriter = new JsonCharArrayWriter(8);
            try {
                this.delegate.addElement(valueWriter, date, request, response, time);
                valueWriter.writeTo(buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.quoteValue) {
                buf.append('\"');
            }
        }

        @Override
        public void cache(Request request) {
            if (this.delegate instanceof AbstractAccessLogValve.CachedElement) {
                ((AbstractAccessLogValve.CachedElement)((Object)this.delegate)).cache(request);
            }
        }
    }

    private static class JsonCharArrayWriter
    extends CharArrayWriter {
        JsonCharArrayWriter(int i) {
            super(i);
        }

        @Override
        public void write(int c) {
            try {
                super.write(JSONFilter.escape((char)c));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void write(char[] c, int off, int len) {
            try {
                super.write(JSONFilter.escape(new String(c, off, len)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void write(String str, int off, int len) {
            CharSequence escaped = JSONFilter.escape(str, off, len);
            super.write(escaped.toString(), 0, escaped.length());
        }
    }
}

