/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Timestamp;
import org.jadira.usertype.dateandtime.joda.util.Formatter;
import org.jadira.usertype.dateandtime.shared.spi.AbstractTimestampColumnMapper;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class TimestampColumnLocalDateTimeMapper
extends AbstractTimestampColumnMapper<LocalDateTime> {
    private static final long serialVersionUID = -7670411089210984705L;

    public LocalDateTime fromNonNullString(String s) {
        return new LocalDateTime((Object)s);
    }

    public LocalDateTime fromNonNullValue(Timestamp value) {
        return Formatter.LOCAL_DATETIME_FORMATTER.parseDateTime(value.toString()).toLocalDateTime();
    }

    public String toNonNullString(LocalDateTime value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(LocalDateTime value) {
        String formattedTimestamp = Formatter.LOCAL_DATETIME_FORMATTER.print((ReadablePartial)value);
        if (formattedTimestamp.endsWith(".")) {
            formattedTimestamp = formattedTimestamp.substring(0, formattedTimestamp.length() - 1);
        }
        Timestamp timestamp = Timestamp.valueOf(formattedTimestamp);
        return timestamp;
    }
}

